---
id: 68594df7779a164e6a61e8ae
title: Step 32
challengeType: 20
dashedName: step-32
---

# --description--

The inbox needs a method to read a specific email. When a user wants to read an email, they'll specify which email number (starting from index 0) they want to see, and the method will display the full email content.

Add a method called `read_email` to your `Inbox` class that takes an `index` parameter. First, check if the inbox is empty and print the message `Inbox is empty.\n` if it is. Add a `return` statement after that to exit the method.

# --hints--

You should define a method named `read_email` in the `Inbox` class that takes `self` and `index` as parameters.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).find_class("Inbox").find_function("read_email").has_args("self, index")`));
    }
})
```

You should check if `self.emails` is empty using `if not self.emails`.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).find_class("Inbox").find_function("read_email").find_ifs()[0].find_conditions()[0].is_equivalent("not self.emails")`));
    }
})
```

You should print `Inbox is empty.\n` if there are no emails and return.

```js
({
    test: () => {
        assert(runPython(`_Node(_code).find_class("Inbox").find_function("read_email").find_ifs()[0].find_body()[0].is_equivalent("print('Inbox is empty.\\\\n')")`));
        assert(runPython(`_Node(_code).find_class("Inbox").find_function("read_email").find_ifs()[0].find_body()[1].is_equivalent("return")`));
    }
})
```

# --seed--

## --seed-contents--

```py
class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject}"
class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

--fcc-editable-region--
    
--fcc-editable-region--
```
