---
id: 6853f70470f45d9c280af659
title: Step 43
challengeType: 20
dashedName: step-43
---

# --description--

Now let's show the timestamp when displaying the full email.

Below the subject, print the received timestamp using `strftime` to format it as `'%Y-%m-%d %H:%M'`. Use the following format:

```py
Received: date
```

Where `date` is formatted as `'%Y-%m-%d %H:%M'`.


# --hints--

You should print the formatted timestamp using `self.timestamp.strftime('%Y-%m-%d %H:%M')`. Add `Received:` followed by a space before it.

```js
({
    test: () => 
    {
        assert(runPython(`_Node(_code).find_class("Email").find_function("display_full_email").has_call('print(f"Received: {self.timestamp.strftime(\\'%Y-%m-%d %H:%M\\')}")')`))
    }
})
```

# --seed--

## --seed-contents--

```py
import datetime

class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.timestamp = datetime.datetime.now()
        self.read = False

    def mark_as_read(self):
        self.read = True

--fcc-editable-region--
    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        
        print(f'Body: {self.body}')
        print('------------\n')
--fcc-editable-region--

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject}"
class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        self.emails[actual_index].display_full_email()

    def delete_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        del self.emails[actual_index]
        print('Email deleted.\n')

```
