---
id: 6853f68dd3affa9adb2e6d99
title: Step 41
challengeType: 20
dashedName: step-41
---

# --description--

Great! Now that you've practiced datetime formatting, remove the `current_time` variable and the print statement from the bottom of your code. We'll integrate timestamps into the `Email` class in the next step.

# --hints--

You should not have the statement `current_time = datetime.datetime.now()")` in your code.

```js
({
    test: () => {
        assert(!runPython(`_Node(_code).has_stmt("current_time = datetime.datetime.now()")`));
    }
})
```

You should not have the practice print statement with `strftime()` in your code.

```js
({
    test: () => {
        assert(!runPython(`_Node(_code).has_call("print(current_time.strftime('%H:%M:%S'))")`));
    }
})
```

# --seed--

## --seed-contents--

```py
import datetime

class Email:
    def __init__(self, sender, receiver, subject, body):
        self.sender = sender
        self.receiver = receiver
        self.subject = subject
        self.body = body
        self.read = False

    def mark_as_read(self):
        self.read = True

    def display_full_email(self):
        self.mark_as_read()
        print('\n--- Email ---')
        print(f'From: {self.sender.name}')
        print(f'To: {self.receiver.name}')
        print(f'Subject: {self.subject}')
        print(f'Body: {self.body}')
        print('------------\n')

    def __str__(self):
        status = 'Read' if self.read else 'Unread'
        return f"[{status}] From: {self.sender.name} | Subject: {self.subject}"
class User:
    def __init__(self, name):
        self.name = name
        self.inbox = Inbox()

    def send_email(self, receiver, subject, body):
        email = Email(sender=self, receiver=receiver, subject=subject, body=body)
        receiver.inbox.receive_email(email)

class Inbox:
    def __init__(self):
        self.emails = []

    def receive_email(self, email):
        self.emails.append(email)

    def list_emails(self):
        if not self.emails:
            print('Your inbox is empty.\n')
            return
        print('\nYour Emails:')
        for i, email in enumerate(self.emails, start=1):
            print(f'{i}. {email}')

    def read_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        self.emails[actual_index].display_full_email()

    def delete_email(self, index):
        if not self.emails:
            print('Inbox is empty.\n')
            return
        actual_index = index - 1
        if actual_index < 0 or actual_index >= len(self.emails):
            print('Invalid email number.\n')
            return
        del self.emails[actual_index]
        print('Email deleted.\n')

--fcc-editable-region--
current_time = datetime.datetime.now()
print(current_time.strftime('%H:%M:%S'))
--fcc-editable-region--
```
