---
id: 68e79d91daf8fb4808f93c47
title: Step 15
challengeType: 20
dashedName: step-15
---

# --description--

After implementing the `apply_discount` method, test your discount strategy. Create an instance of `PercentageDiscount` with `10` percent and assign it to a variable named `discount`. Then apply the discount using `discount.apply_discount(product)`, and print the result to see the discount in action.

# --hints--

You should create a variable named `discount` with a `PercentageDiscount` instance.

```js
({
  test: () => runPython(`
    assert _Node(_code).has_variable("discount")
    assert isinstance(discount, PercentageDiscount)
  `)
})
```

Your `PercentageDiscount` instance should be initialized with `10` percent.

```js
({
  test: () => runPython(`assert discount.percent == 10`)
})
```

You should call `discount.apply_discount(product)` and print the result.

```js
({
  test: () => runPython(`assert _Node(_code).has_call("print(discount.apply_discount(product))")`)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70
    
    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)

--fcc-editable-region--
```
