---
id: 68e52994bc7ea2e3dec530a6
title: Step 30
challengeType: 20
dashedName: step-30
---

# --description--

Now let's test the complete discount system! Add an `if` statement checking if `__name__ == '__main__'` and move `product = Product('Wireless Mouse', 50.0)` inside it.

After that, inside the `if` block, create a variable `user_tier` and set it to the string `Premium`. Then create a variable `strategies` set to a list of strategies containing `PercentageDiscount(10)`, `FixedAmountDiscount(5)`, and `PremiumUserDiscount()`.

# --hints--

You should have an `if` statement checking if `__name__ == '__main__'`.

```js
({
  test: () => runPython(`assert _Node(_code).find_ifs()[0].find_conditions()[0].is_equivalent('__name__ == "__main__"')`)
})
```

You should move `product = Product('Wireless Mouse', 50.0)` inside the `if` block.

```js
({
  test: () => runPython(`assert _Node(_code).find_ifs()[0].has_stmt("product = Product('Wireless Mouse', 50.0)")`)
})
```

You should set `user_tier` to the string `Premium` within the `if` block.

```js
({
  test: () => runPython(`assert _Node(_code).find_ifs()[0].has_stmt('user_tier = "Premium"')`)
})
```

You should create a list named `strategies` containing `PercentageDiscount(10)`, `FixedAmountDiscount(5)`, and `PremiumUserDiscount()`.

```js
({
  test: () => runPython(`assert _Node(_code).find_ifs()[0].has_stmt('strategies = [PercentageDiscount(10), FixedAmountDiscount(5), PremiumUserDiscount()]')`)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
from typing import List

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return product.price * 0.9 > self.amount

    def apply_discount(self, product: Product) -> float:
        return product.price - self.amount

class PremiumUserDiscount(DiscountStrategy):
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return user_tier.lower() == 'premium'

    def apply_discount(self, product: Product) -> float:
        return product.price * 0.8

class DiscountEngine:
    def __init__(self, strategies: List[DiscountStrategy]) -> None:
        self.strategies = strategies

    def calculate_best_price(self, product: Product, user_tier: str) -> float:
        prices = [product.price]

        for strategy in self.strategies:
            if strategy.is_applicable(product, user_tier):
                discounted = strategy.apply_discount(product)
                prices.append(discounted)

        return min(prices)
--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
--fcc-editable-region--
```
