---
id: 68e52994bc7ea2e3dec530a2
title: Step 25
challengeType: 20
dashedName: step-25
---

# --description--

Now create a method named `calculate_best_price` in your `DiscountEngine` class. This method should take `self`, `product`, and `user_tier` as parameters, and return a `float`.

For now, just use `pass` in the method body. You'll implement the logic in the next steps.

# --hints--

Your `DiscountEngine` class should have a method named `calculate_best_price`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("DiscountEngine").has_function("calculate_best_price")`)
})
```

Your `calculate_best_price` method should have parameters `self`, `product: Product`, and `user_tier: str`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("DiscountEngine").find_function("calculate_best_price").has_args("self, product:Product, user_tier:str")`)
})
```

Your `calculate_best_price` method should have a return type hint of `-> float`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("DiscountEngine").find_function("calculate_best_price").has_returns("float")`)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
from typing import List

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return product.price * 0.9 > self.amount

    def apply_discount(self, product: Product) -> float:
        return product.price - self.amount

class PremiumUserDiscount(DiscountStrategy):
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return user_tier.lower() == 'premium'

    def apply_discount(self, product: Product) -> float:
        return product.price * 0.8

class DiscountEngine:
    def __init__(self, strategies: List[DiscountStrategy]) -> None:
        self.strategies = strategies
--fcc-editable-region--
    
--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))

fixed_discount = FixedAmountDiscount(5)
print(fixed_discount.apply_discount(product))
```
