---
id: 68e52994bc7ea2e3dec5309f
title: Step 22
challengeType: 20
dashedName: step-22
---

# --description--

Now implement the `apply_discount` method for `PremiumUserDiscount`. This should apply a 20% discount to premium users.

Return `product.price * 0.8` (which represents 80% of the original price, i.e., 20% off).

# --hints--

Your `PremiumUserDiscount` class should have an `apply_discount` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PremiumUserDiscount").has_function("apply_discount")`)
})
```

Your `apply_discount` method should have parameters `self` and `product: Product`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PremiumUserDiscount").find_function("apply_discount").has_args("self, product: Product")`)
})
```

Your `apply_discount` method should have a return type hint of `-> float`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("PremiumUserDiscount").find_function("apply_discount").has_returns("float")`)
})
```

Your `apply_discount` method should return `product.price * 0.8`.

```js
({
  test: () => runPython(`
    test_product = Product("Test", 100.0)
    discount = PremiumUserDiscount()
    result = discount.apply_discount(test_product)
    assert result == 80.0
  `)
})
```

Your `apply_discount` method should apply a 20% discount (80% of original price).

```js
({
  test: () => runPython(`
    test_product = Product("Test", 50.0)
    discount = PremiumUserDiscount()
    result = discount.apply_discount(test_product)
    assert result == 40.0
  `)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return product.price * 0.9 > self.amount

    def apply_discount(self, product: Product) -> float:
        return product.price - self.amount

class PremiumUserDiscount(DiscountStrategy):
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return user_tier.lower() == 'premium'
--fcc-editable-region--
    
--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))

fixed_discount = FixedAmountDiscount(5)
print(fixed_discount.apply_discount(product))
```
