---
id: 68e5293bd00d2fe134f58988
title: Step 17
challengeType: 20
dashedName: step-17
---

# --description--

Implement the `is_applicable` method for your `FixedAmountDiscount` class. A fixed amount discount should only be applied if it makes sense economically.

Return `True` if `product.price * 0.9` is greater than `self.amount`, otherwise return `False`. This ensures the discount doesn't exceed 10% of the original price, which would be unrealistic.

# --hints--

Your `FixedAmountDiscount` class should have an `is_applicable` method.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").has_function("is_applicable")`)
})
```

Your `is_applicable` method should have parameters `self`, `product: Product`, and `user_tier: str`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").find_function("is_applicable").has_args("self, product:Product, user_tier:str")`)
})
```

Your `is_applicable` method should have a return type hint of `-> bool`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("FixedAmountDiscount").find_function("is_applicable").has_returns("bool")`)
})
```

Your `is_applicable` method should return `True` when `product.price * 0.9` is greater than `self.amount`.

```js
({
  test: () => runPython(`
    # Add stub method to make class instantiable for testing
    class TestFixedAmountDiscount(FixedAmountDiscount):
        def apply_discount(self, product):
            return 0

    test_product = Product("Test", 100.0)
    discount = TestFixedAmountDiscount(50)
    assert discount.is_applicable(test_product, "regular") == True
  `)
})
```

Your `is_applicable` method should return `False` when `product.price * 0.9` is less than or equal to `self.amount`.

```js
({
  test: () => runPython(`
    # Add stub method to make class instantiable for testing
    class TestFixedAmountDiscount(FixedAmountDiscount):
        def apply_discount(self, product):
            return 0

    test_product = Product("Test", 100.0)
    discount = TestFixedAmountDiscount(95)
    assert discount.is_applicable(test_product, "regular") == False
  `)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

class DiscountStrategy(ABC):
    @abstractmethod
    def is_applicable(self, product: Product, user_tier: str) -> bool:
        pass

    @abstractmethod
    def apply_discount(self, product: Product) -> float:
        pass

class PercentageDiscount(DiscountStrategy):
    def __init__(self, percent: int) -> None:
        self.percent = percent

    def is_applicable(self, product: Product, user_tier: str) -> bool:
        return self.percent <= 70

    def apply_discount(self, product: Product) -> float:
        return product.price * (1 - self.percent / 100)

class FixedAmountDiscount(DiscountStrategy):
    def __init__(self, amount: int) -> None:
        self.amount = amount
--fcc-editable-region--
    
--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)

discount = PercentageDiscount(10)
print(discount.apply_discount(product))
```
