---
id: 68e5293bd00d2fe134f58982
title: Step 9
challengeType: 20
dashedName: step-9
---

# --description--

As discussed in the previous lesson, abstract methods are methods that must be implemented by any class that inherits from the abstract base class. They serve as a contract, ensuring that all discount strategies will have certain required methods.

Inside your `DiscountStrategy` class, define a method named `is_applicable`. Use the `@abstractmethod` decorator above the method definition. The method should have the following parameters: `self`, `product`, and `user_tier`. Use the `pass` statement in the method body.

Add type hints to make the method signature clear: `product` should be of type `Product`, `user_tier` should be of type `str`.


# --hints--

Your `DiscountStrategy` class should have a method named `is_applicable`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("DiscountStrategy").has_function("is_applicable")`)
})
```

Your `is_applicable` method should have the `@abstractmethod` decorator.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("DiscountStrategy").find_function("is_applicable").has_decorators("abstractmethod")`)
})
```

Your `is_applicable` method should have parameters `self`, `product: Product`, and `user_tier: str`.

```js
({
  test: () => runPython(`assert _Node(_code).find_class("DiscountStrategy").find_function("is_applicable").has_args("self,product:Product,user_tier:str")`)
})
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Product:
    def __init__(self, name: str, price: float) -> None:
        self.name = name
        self.price = price

    def __str__(self) -> str:
        return f'{self.name} - ${self.price}'

--fcc-editable-region--
class DiscountStrategy(ABC):
    pass
--fcc-editable-region--
product = Product('Wireless Mouse', 50.0)
print(product)
```
