---
id: 5dfa2407b521be39a3de7be1
title: Step 15
challengeType: 0
dashedName: step-15
---

# --description--

To open links in a new tab, you can use the `target` attribute on the anchor (`a`) element. 

The `target` attribute specifies where to open the linked document. `target="_blank"` opens the linked document in a new tab or window.

Here is the basic syntax for an `a` element with a `target` attribute:

```html
<a href="https://www.freecodecamp.org" target="_blank">freeCodeCamp</a>
```

Add a `target` attribute with the value `_blank` to the anchor (`a`) element's opening tag, so that the link opens in a new tab.

# --hints--

Your `p` element should have a nested anchor (`a`) element with the text `cat photos`. You may have deleted it or have a typo.

```js
const anchor = document.querySelectorAll('p > a')[1];
assert.equal(
    anchor?.innerText?.toLowerCase().trim().replace(/\s+/g, ' '), 'cat photos'
);
```

Your anchor (`a`) element does not have a `target` attribute. Check that there is a space after the opening tag's name and/or there are spaces before all attribute names.

```js
assert.isTrue(document.querySelectorAll('a')[1]?.hasAttribute('target'));
```

The value of the `target` attribute should be `_blank`. You have either omitted the value or have a typo. Remember that attribute values should be surrounded with quotation marks.

```js
assert.equal(document.querySelectorAll('a')[1]?.getAttribute('target'), '_blank');
```

# --seed--

## --seed-contents--

```html
<html>
  <body>
    <main>
      <h1>CatPhotoApp</h1>
      <h2>Cat Photos</h2>
      <!-- TODO: Add link to cat photos -->
      <p>Everyone loves <a href="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg">cute cats</a> online!</p>
--fcc-editable-region--
      <p>See more <a href="https://freecatphotoapp.com">cat photos</a> in our gallery.</p>
--fcc-editable-region--
      <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back.">
    </main>
  </body>
</html>
```
