---
id: 63c21839f56eaf3ef4e027c4
title: Step 50
challengeType: 0
dashedName: step-50
---

# --description--

Create another `label` element (on a new line) at the end of your `HTMLString`. This `label` should have the text `Entry # Calories`, using your template literal syntax to replace `#` with the value of `entryNumber`, and the `for` attribute set to `X-#-calories`, where `X` is the `value` of `entryDropdown` and `#` is the value of `entryNumber`.

# --hints--

You should have two `label` elements in your `HTMLString`.

```js
const HTMLstring = code.split(/HTMLString\s*=/)[1];
assert.equal(HTMLstring.match(/<label/g).length, 2);
```

Your new `label` element should be on a new line.

```js
const HTMLstring = code.split(/HTMLString\s*=/)[1];
assert.equal(HTMLstring.match(/\n\s*<label/g).length, 2);
```

Your new `label` element should come after your `input` element.

```js
const HTMLstring = code.split(/HTMLString\s*=/)[1];
const inputIndex = HTMLstring.indexOf("<input");
const labelIndex = HTMLstring.lastIndexOf("<label");
assert.isBelow(inputIndex, labelIndex);
```

Your new `label` element should have a `for` attribute set to `${entryDropdown.value}-${entryNumber}-calories`.

```js
const HTMLstring = code.split(/HTMLString\s*=/)[1];
const label = HTMLstring.match(/<label.*>.*<\/label>/g)[1];
assert.match(label, /<label\s+for="\$\{entryDropdown.value\}-\$\{entryNumber\}-calories"\s*>/)
```

Your new `label` element should have the text `Entry ${entryNumber} Calories`.

```js
const HTMLstring = code.split(/HTMLString\s*=/)[1];
const label = HTMLstring.match(/<label.*>.*<\/label>/g)[1];
assert.match(label, /<label\s+for="\$\{entryDropdown.value\}-\$\{entryNumber\}-calories"\s*>Entry\s\$\{entryNumber\}\sCalories<\/label>/);
```

You should not modify your existing elements.

```js
const HTMLstring = code.split(/HTMLString\s*=/)[1];
assert.match(HTMLstring, /`\n\s*<label\s+for="\$\{entryDropdown.value\}-\$\{entryNumber\}-name"\s*>Entry\s\$\{entryNumber\}\sName<\/label>\n\s*<input\stype="text"\sid="\$\{entryDropdown.value\}-\$\{entryNumber\}-name"\splaceholder="Name"\s\/>\n\s*<label\s+for="\$\{entryDropdown.value\}-\$\{entryNumber\}-calories"\s*>Entry\s\$\{entryNumber\}\sCalories<\/label>/)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="styles.css" />
    <title>Calorie Counter</title>
  </head>
  <body>
    <main>
      <h1>Calorie Counter</h1>
      <div class="container">
        <form id="calorie-counter">
          <label for="budget">Budget</label>
          <input
            type="number"
            min="0"
            id="budget"
            placeholder="Daily calorie budget"
            required
          />
          <fieldset id="breakfast">
            <legend>Breakfast</legend>
            <div class="input-container"></div>
          </fieldset>
          <fieldset id="lunch">
            <legend>Lunch</legend>
            <div class="input-container"></div>
          </fieldset>
          <fieldset id="dinner">
            <legend>Dinner</legend>
            <div class="input-container"></div>
          </fieldset>
          <fieldset id="snacks">
            <legend>Snacks</legend>
            <div class="input-container"></div>
          </fieldset>
          <fieldset id="exercise">
            <legend>Exercise</legend>
            <div class="input-container"></div>
          </fieldset>
          <div class="controls">
            <span>
              <label for="entry-dropdown">Add food or exercise:</label>
              <select id="entry-dropdown" name="options">
                <option value="breakfast" selected>Breakfast</option>
                <option value="lunch">Lunch</option>
                <option value="dinner">Dinner</option>
                <option value="snacks">Snacks</option>
                <option value="exercise">Exercise</option>
              </select>
              <button type="button" id="add-entry">Add Entry</button>
            </span>
          </div>
          <div>
            <button type="submit">
              Calculate Remaining Calories
            </button>
            <button type="button" id="clear">Clear</button>
          </div>
        </form>
        <div id="output" class="output hide"></div>
      </div>
    </main>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
:root {
  --light-grey: #f5f6f7;
  --dark-blue: #0a0a23;
  --fcc-blue: #1b1b32;
  --light-yellow: #fecc4c;
  --dark-yellow: #feac32;
  --light-pink: #ffadad;
  --dark-red: #850000;
  --light-green: #acd157;
}

body {
  font-family: "Lato", Helvetica, Arial, sans-serif;
  font-size: 18px;
  background-color: var(--fcc-blue);
  color: var(--light-grey);
}

h1 {
  text-align: center;
}

.container {
  width: 90%;
  max-width: 680px;
}

h1,
.container,
.output {
  margin: 20px auto;
}

label,
legend {
  font-weight: bold;
}

.input-container {
  display: flex;
  flex-direction: column;
}

button {
  cursor: pointer;
  text-decoration: none;
  background-color: var(--light-yellow);
  border: 2px solid var(--dark-yellow);
}

button,
input,
select {
  min-height: 24px;
  color: var(--dark-blue);
}

fieldset,
label,
button,
input,
select {
  margin-bottom: 10px;
}

.output {
  border: 2px solid var(--light-grey);
  padding: 10px;
  text-align: center;
}

.hide {
  display: none;
}

.output span {
  font-weight: bold;
  font-size: 1.2em;
}

.surplus {
  color: var(--light-pink);
}

.deficit {
  color: var(--light-green);
}
```

```js
const calorieCounter = document.getElementById('calorie-counter');
const budgetNumberInput = document.getElementById('budget');
const entryDropdown = document.getElementById('entry-dropdown');
const addEntryButton = document.getElementById('add-entry');
const clearButton = document.getElementById('clear');
const output = document.getElementById('output');
let isError = false;

function cleanInputString(str) {
  const regex = /[+-\s]/g;
  return str.replace(regex, '');
}

function isInvalidInput(str) {
  const regex = /\d+e\d+/i;
  return str.match(regex);
}

--fcc-editable-region--
function addEntry() {
  const targetInputContainer = document.querySelector(`#${entryDropdown.value} .input-container`);
  const entryNumber = targetInputContainer.querySelectorAll('input[type="text"]').length;
  const HTMLString = `
  <label for="${entryDropdown.value}-${entryNumber}-name">Entry ${entryNumber} Name</label>
  <input type="text" id="${entryDropdown.value}-${entryNumber}-name" placeholder="Name" />`;
}
--fcc-editable-region--
```
