---
id: 5f3ef6e056bdde6ae6892ba2
title: Step 54
challengeType: 0
dashedName: step-54
---

# --description--

It is a bit boring for all the text to have the same `font-family`. You can still have the majority of the text `sans-serif` and make just the `h1` and `h2` elements different using a different selector.

Style both the `h1` and the `h2` elements using a single selector so that these elements' text use `Impact` font.

# --hints--

You should use an `h1, h2` selector.

```js
const h1h2Selector = new __helpers.CSSHelp(document).getStyle('h1, h2');
assert.exists(h1h2Selector);
```

You should set the `font-family` to `Impact`.

```js
const hasFontFamily = new __helpers.CSSHelp(document).getCSSRules().some(x => x.style['font-family'].toLowerCase() === 'impact');
assert.isTrue(hasFontFamily);
```

Your `h1` element should have a `font-family` of `Impact`.

```js
const h1Element = document.querySelector("h1"); 

const headingFont = window.getComputedStyle(h1Element)?.getPropertyValue('font-family');
assert.match(headingFont,/impact/i);
```

Your `h2` element should have a `font-family` of `Impact`.

```js
const h2Element = document.querySelector("h2"); 
const headingFont = window.getComputedStyle(h2Element)?.getPropertyValue('font-family');
assert.match(headingFont,/impact/i);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Cafe Menu</title>
    <link href="styles.css" rel="stylesheet"/>
  </head>
  <body>
    <div class="menu">
      <main>
        <h1>CAMPER CAFE</h1>
        <p>Est. 2020</p>
        <section>
          <h2>Coffee</h2>
          <article class="item">
            <p class="flavor">French Vanilla</p><p class="price">3.00</p>
          </article>
          <article class="item">
            <p class="flavor">Caramel Macchiato</p><p class="price">3.75</p>
          </article>
          <article class="item">
            <p class="flavor">Pumpkin Spice</p><p class="price">3.50</p>
          </article>
          <article class="item">
            <p class="flavor">Hazelnut</p><p class="price">4.00</p>
          </article>
          <article class="item">
            <p class="flavor">Mocha</p><p class="price">4.50</p>
          </article>
        </section>
        <section>
          <h2>Desserts</h2>
          <article class="item">
            <p class="dessert">Donut</p><p class="price">1.50</p>
          </article>
          <article class="item">
            <p class="dessert">Cherry Pie</p><p class="price">2.75</p>
          </article>
          <article class="item">
            <p class="dessert">Cheesecake</p><p class="price">3.00</p>
          </article>
          <article class="item">
            <p class="dessert">Cinnamon Roll</p><p class="price">2.50</p>
          </article>
        </section>
      </main>
    </div>
  </body>
</html>
```

```css
body {
  background-image: url(https://cdn.freecodecamp.org/curriculum/css-cafe/beans.jpg);
  font-family: sans-serif;
}

h1, h2, p {
  text-align: center;
}

.menu {
  width: 80%;
  background-color: burlywood;
  margin-left: auto;
  margin-right: auto;
  padding: 20px;
  max-width: 500px;
}

--fcc-editable-region--

--fcc-editable-region--

.item p {
  display: inline-block;
}

.flavor, .dessert {
  text-align: left;
  width: 75%;
}

.price {
  text-align: right;
  width: 25%
}
```

