---
id: 5f3c866de7a5b784048f94b1
title: Step 32
challengeType: 0
dashedName: step-32
---

# --description--

That is kind of what you want, but now it would be nice if the flavor and price were on the same line. `p` elements are <dfn>block-level</dfn> elements, so they take up the entire width of their parent element.

To get them on the same line, you need to apply some styling to the `p` elements so they behave more like <dfn>inline</dfn> elements.

To do that, start by adding a `class` attribute with the value `item` to the first `article` element under the `Coffee` heading.

# --hints--

You should apply the `item` class to your `article` element.

```js
const el = document.querySelector('article.item');
assert.exists(el);
```

You should only have one `item` class element.

```js
const elements = document.querySelectorAll('.item');
assert.lengthOf(elements, 1);
```

Your first `article` element should have the `item` class.

```js
assert.equal(document.querySelector('article')?.className, 'item');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Cafe Menu</title>
    <link href="styles.css" rel="stylesheet"/>
  </head>
  <body>
    <div class="menu">
      <main>
        <h1>CAMPER CAFE</h1>
        <p>Est. 2020</p>
        <section>
--fcc-editable-region--
          <h2>Coffee</h2>
          <article>
            <p class="flavor">French Vanilla</p>
            <p class="price">3.00</p>
          </article>
--fcc-editable-region--
          <article>
            <p>Caramel Macchiato</p>
            <p>3.75</p>
          </article>
          <article>
            <p>Pumpkin Spice</p>
            <p>3.50</p>
          </article>
          <article>
            <p>Hazelnut</p>
            <p>4.00</p>
          </article>
          <article>
            <p>Mocha</p>
            <p>4.50</p>
          </article>
        </section>
      </main>
    </div>
  </body>
</html>
```

```css
body {
  background-image: url(https://cdn.freecodecamp.org/curriculum/css-cafe/beans.jpg);
}

h1, h2, p {
  text-align: center;
}

.menu {
  width: 80%;
  background-color: burlywood;
  margin-left: auto;
  margin-right: auto;
}

.flavor {
  text-align: left;
}

.price {
  text-align: right;
}
```
