---
id: 66a334a1a7cca6354999f9bf
title: Step 10
challengeType: 0
dashedName: step-10
---

# --description--

For the first blog post, you will use an <dfn>article</dfn> element.

The `article` element represents self contained content on a web page.

```html
<article>
  <h1>Example heading</h1>
  <p>Example article text</p>
</article>
```

Below the `h2` element, add an `article` element.

Inside the `article` element, add an `h3` element with the text `Mr. Whiskers' First Day Home`.

The reason an `h3` is used here is that maintaining a proper structural hierarchy for heading elements is important. Since the posts subheading is an `h2` element, the next level down in the hierarchy would be an `h3`.

# --hints--

Your code should have an opening `article` tag.

```js
assert.match(code, /<article>/i);
```

Your code should have a closing `article` tag.

```js
assert.match(code, /<\/article>/i);
```

Your `article` element should be within your `section` element with the `id` set to `posts`.

```js
const articleElement = document.querySelector('#posts article');
assert.strictEqual(articleElement?.parentElement.tagName, 'SECTION');
```

Your code should have an opening `h3` tag.

```js
assert.match(code, /<h3>/i);
```

Your code should have a closing `h3` tag.

```js
assert.match(code, /<\/h3>/i);
```

Your `h3` element should have the text of `Mr. Whiskers' First Day Home`.

```js
const h3Element = document.querySelector('h3');
assert.strictEqual(h3Element?.innerText.trim(), "Mr. Whiskers' First Day Home");
```

Your `h3` element should be within your `article` element.

```js
const h3Element = document.querySelector('#posts article h3');
assert.strictEqual(h3Element?.parentElement.tagName, 'ARTICLE');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <title>Mr. Whiskers' Blog</title>
    <meta charset="UTF-8" />
  </head>
  <body>
    <header>
      <h1>Welcome to Mr. Whiskers' Blog Page!</h1>
      <figure>
        <img
          src="https://cdn.freecodecamp.org/curriculum/css-photo-gallery/1.jpg"
          alt="a cat in the garden"
        />
        <figcaption>Mr. Whiskers in the Garden</figcaption>
      </figure>
      <nav>
        <ul>
          <li><a href="#about">About</a></li>
          <li><a href="#posts">Posts</a></li>
          <li><a href="#contact">Contact</a></li>
        </ul>
      </nav>
    </header>
    <main>
      <section id="about">
        <h2>About</h2>
        <p>
          Hi there! I'm Jane Doe, a passionate writer who finds endless inspiration in the antics of my beloved cat, Mr. Whiskers.
        </p>
        <p>
          His playful nature and boundless energy keeps me on my toes. I love him so much.
        </p>
      </section>
--fcc-editable-region--
      <section id="posts">
        <h2>Posts</h2>
        
      </section>
--fcc-editable-region--
    </main>
  </body>
</html>
```
