---
id: 61fd8fd08af43372f02952d0
title: Step 19
challengeType: 0
dashedName: step-19
---

# --description--

Give each `th` element a `span` element with the class set to `sr-only` and the following text, in order: `2019`, `2020`, and `2021`.

# --hints--

Each of your `th` elements should have a `span` element.

```js
const ths = [
  ...document.querySelectorAll('table')?.[1]?.querySelectorAll('th')
];
ths?.forEach(th => {
  assert.lengthOf(th?.children, 1);
  assert.strictEqual(th?.children?.[0]?.localName, 'span');
});
```

Each of your new `span` elements should have the `class` attribute set to `sr-only`.

```js
const ths = [
  ...document.querySelectorAll('table')?.[1]?.querySelectorAll('th')
];
ths?.forEach(th => {
  assert.isTrue(th?.children?.[0]?.classList?.contains('sr-only'));
});
```

Your first `span` element should have the text `2019`.

```js
const table = document.querySelectorAll('table')?.[1];
const th = table.querySelectorAll('th')?.[0];
assert.strictEqual(th.children?.[0]?.textContent.trim(), '2019');
```

Your second `span` element should have the text `2020`.

```js
const table = document.querySelectorAll('table')?.[1];
const th = table.querySelectorAll('th')?.[1];
assert.strictEqual(th?.children?.[0]?.textContent.trim(), '2020');
```

Your third `span` element should have the text `2021`.

```js
const table = document.querySelectorAll('table')?.[1];
const th = table.querySelectorAll('th')?.[2];
assert.strictEqual(th?.children?.[0]?.textContent.trim(), '2021');
```

Your `td` element should be empty.

```js
const table = document.querySelectorAll('table')?.[1];
const td = table.querySelectorAll('td')?.[0];
assert.strictEqual(td?.textContent.trim(), '');
assert.lengthOf(td?.children, 0);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Balance Sheet</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <main>
      <section>
        <h1>
          <span class="flex">
            <span>AcmeWidgetCorp</span>
            <span>Balance Sheet</span>
          </span>
        </h1>
        <div id="years" aria-hidden="true">
          <span class="year">2019</span>
          <span class="year">2020</span>
          <span class="year">2021</span>
        </div>
        <div class="table-wrap">
          <table>
            <caption>
              Assets
            </caption>
            <thead>
              <tr>
                <td></td>
                <th><span class="sr-only year">2019</span></th>
                <th><span class="sr-only year">2020</span></th>
                <th class="current"><span class="sr-only year">2021</span></th>
              </tr>
            </thead>
            <tbody>
              <tr class="data">
                <th>Cash <span class="description">This is the cash we currently have on hand.</span></th>
                <td>$25</td>
                <td>$30</td>
                <td class="current">$28</td>
              </tr>
              <tr class="data">
                <th>Checking <span class="description">Our primary transactional account.</span></th>
                <td>$54</td>
                <td>$56</td>
                <td class="current">$53</td>
              </tr>
              <tr class="data">
                <th>Savings <span class="description">Funds set aside for emergencies.</span></th>
                <td>$500</td>
                <td>$650</td>
                <td class="current">$728</td>
              </tr>
              <tr class="total">
                <th>Total <span class="sr-only">Assets</span></th>
                <td>$579</td>
                <td>$736</td>
                <td class="current">$809</td>
              </tr>
            </tbody>
          </table>
--fcc-editable-region--
          <table>
            <caption>
              Liabilities
            </caption>
            <thead>
              <tr>
                <td></td>
                <th></th>
                <th></th>
                <th></th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
--fcc-editable-region--
          <table>
          </table>
        </div>
      </section>
    </main>
  </body>
</html>
```

```css

```
