---
id: 614202874ca576084fca625f
title: Step 16
challengeType: 0
dashedName: step-16
---

# --description--

Every `region` role requires a label, which helps screen reader users understand the purpose of the region. One method for adding a label is to add a heading element inside the region and then reference it with the `aria-labelledby` attribute.

Add the following `aria-labelledby` attributes to the `section` elements:

- `student-info`
- `html-questions`
- `css-questions`

Then, within each `section` element, nest one `h2` element with an `id` matching the corresponding `aria-labelledby` attribute. Give each `h2` suitable text content.

# --hints--

You should give the first `section` element an `aria-labelledby` attribute of `student-info`.

```js
assert.equal(document.querySelectorAll('section')?.[0]?.getAttribute('aria-labelledby'), 'student-info');
```

You should give the second `section` element an `aria-labelledby` attribute of `html-questions`.

```js
assert.equal(document.querySelectorAll('section')?.[1]?.getAttribute('aria-labelledby'), 'html-questions');
```

You should give the third `section` element an `aria-labelledby` attribute of `css-questions`.

```js
assert.equal(document.querySelectorAll('section')?.[2]?.getAttribute('aria-labelledby'), 'css-questions');
```

You should nest one `h2` element within the first `section` element.

```js
assert.equal(document.querySelectorAll('section')?.[0]?.querySelectorAll('h2')?.length, 1);
```

You should nest one `h2` element within the second `section` element.

```js
assert.equal(document.querySelectorAll('section')?.[1]?.querySelectorAll('h2')?.length, 1);
```

You should nest one `h2` element within the third `section` element.

```js
assert.equal(document.querySelectorAll('section')?.[2]?.querySelectorAll('h2')?.length, 1);
```

You should give the first `h2` element an `id` attribute of `student-info`.

```js
assert.equal(document.querySelectorAll('h2')?.[0]?.id, 'student-info');
```

You should give the second `h2` element an `id` attribute of `html-questions`.

```js
assert.equal(document.querySelectorAll('h2')?.[1]?.id, 'html-questions');
```

You should give the third `h2` element an `id` attribute of `css-questions`.

```js
assert.equal(document.querySelectorAll('h2')?.[2]?.id, 'css-questions');
```

You should give the first `h2` element suitable text content. _Hint: I would have chosen `Student Info`_

```js
assert.isNotEmpty(document.querySelectorAll('h2')[0]?.textContent.trim());
```

You should give the second `h2` element suitable text content. _Hint: I would have chosen `HTML`_

```js
assert.isNotEmpty(document.querySelectorAll('h2')[1]?.textContent.trim());
```

You should give the third `h2` element suitable text content. _Hint: I would have chosen `CSS`_

```js
assert.isNotEmpty(document.querySelectorAll('h2')[2]?.textContent.trim());
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="description" content="freeCodeCamp Accessibility Quiz practice project" />
    <title>Accessibility Quiz</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <header>
      <img id="logo" alt="freeCodeCamp" src="https://cdn.freecodecamp.org/platform/universal/fcc_primary.svg">
      <h1>HTML/CSS Quiz</h1>
      <nav>
        <ul>
          <li><a>INFO</a></li>
          <li><a>HTML</a></li>
          <li><a>CSS</a></li>
        </ul>
      </nav>
    </header>
    <main>
--fcc-editable-region--
      <form method="post" action="https://freecodecamp.org/practice-project/accessibility-quiz">
        <section role="region"></section>
        <section role="region"></section>
        <section role="region"></section>
      </form>
--fcc-editable-region--
    </main>
  </body>
</html>

```

```css
body {
  background: #f5f6f7;
  color: #1b1b32;
  font-family: Helvetica;
  margin: 0;
}

header {
  width: 100%;
  height: 50px;
  background-color: #1b1b32;
  display: flex;
}

#logo {
  width: max(10rem, 18vw);
  background-color: #0a0a23;
  aspect-ratio: 35 / 4;
  padding: 0.4rem;
}

h1 {
  color: #f1be32;
  font-size: min(5vw, 1.2em);
}

nav {
  width: 50%;
  max-width: 300px;
  height: 50px;
}

nav > ul {
  display: flex;
  justify-content: space-evenly;
}
```
