---
id: 671a915858de057ad84c5dbd
title: Styling Forms Review
challengeType: 31
dashedName: review-styling-forms
---

# --description--

## Best Practices for Styling Inputs

- **Styling Inputs**: As with all text elements, you need to ensure the styles you apply to text inputs are accessible. This means the font needs to be adequately sized, and the color needs to have sufficient contrast with the background. Input elements are also focusable. When you are editing your styles, you should take care that you preserve a noticeable indicator when the element has focus, such as a bold border.

## Using `appearance: none` for Inputs

- **`appearance: none`**: Browsers apply default styling to a lot of elements. The `appearance: none` CSS property gives you complete control over the styling, but comes with some caveats. When building custom styles for input elements, you will need to make sure focus and error indicators are still present.

## Commons Issues Styling `datetime-local` and `color` Properties

- **Common Issues**: These special types of inputs rely on complex pseudo-elements to create things like date and color pickers. This presents a significant challenge for styling these inputs. One challenge is that the default styling is entirely browser-dependent, so the CSS you write to make the picker look the way you intend may be entirely different on another browser.

# --assignment--

Review the Styling Forms topics and concepts.
