---
id: 683766860f71d4a96e429f3a
title: JavaScript and Accessibility Review
challengeType: 31
dashedName: review-js-a11y
---

# --description--

## Common ARIA Accessibility Attributes

- **`aria-expanded` attribute**: Used to convey the state of a toggle (or disclosure) feature to screen reader users.

```html
<button aria-expanded="true">Menu</button>
```

- **`aria-haspopup` attribute**: This state is used to indicate that an interactive element will trigger a pop-up element when activated. You can only use the `aria-haspopup` attribute when the pop-up has one of the following roles: `menu`, `listbox`, `tree`, `grid`, or `dialog`. The value of `aria-haspopup` must be either one of these roles or `true`, which is the same as `menu`.

```html
<button 
  id="menubutton"
  aria-haspopup="menu"
  aria-controls="filemenu"
  aria-expanded="false"
>
    File
</button>

<ul 
  id="filemenu"
  role="menu"
  aria-labelledby="menubutton"
  hidden
>
  <li role="menuitem" tabindex="-1">Open</li>
  <li role="menuitem" tabindex="-1">New</li>
  <li role="menuitem" tabindex="-1">Save</li>
  <li role="menuitem" tabindex="-1">Delete</li>
</ul>
```

- **`aria-checked` attribute**: This attribute is used to indicate whether an element is in the checked state. It is most commonly used when creating custom checkboxes, radio buttons, switches, and listboxes.

```html
<div role="checkbox" aria-checked="true" tabindex="0">Checkbox</div>
```

- **`aria-disabled` attribute**: This state is used to indicate that an element is disabled only to people using assistive technologies, such as screen readers.

```html
<div role="button" tabindex="-1" aria-disabled="true">Edit</div>
```

- **`aria-selected` attribute**: This state is used to indicate that an element is selected. You can use this state on custom controls like a tabbed interface, a listbox, or a grid.

```html
<div role="tablist">
  <button role="tab" aria-selected="true">Tab 1</button>
  <button role="tab" aria-selected="false">Tab 2</button>
  <button role="tab" aria-selected="false">Tab 3</button>
</div>
```

- **`aria-controls` attribute**: Used to associate an element with another element that it controls. This helps people using assistive technologies understand the relationship between the elements.

```html
<div role="tablist">
  <button 
    role="tab"
    id="tab1"
    aria-controls="section1"
    aria-selected="true"
  >
    Tab 1
  </button>
  <button
    role="tab"
    id="tab2"
    aria-controls="section2"
    aria-selected="false"
  >
    Tab 2
  </button>
  <button
    role="tab"
    id="tab3"
    aria-controls="section3"
    aria-selected="false"
  >
    Tab 3
  </button>
</div>
```

- **`hidden` attribute**: Hides inactive panels from both visual and assistive technology users.

## Working with Live Regions and Dynamic Content

- **`aria-live` attribute**: Makes part of a webpage a live region, meaning any updates inside that area will be announced by a screen reader so users don't miss important changes.
- **`polite` value**: Most live regions use this value. This value means that the update is not urgent, so the screen reader can wait until it finishes any current announcement or the user completes their current action before announcing the update.

Here is an example of a live region that is dynamically updated by JavaScript:

```html
<div aria-live="polite" id="status"></div>
```

```js
const statusEl = document.getElementById("status");
statusEl.textContent = "Your file has been successfully uploaded.";
```

- **`contenteditable` attribute**: Turns the element into a live editor, allowing users to update its content as if it were a text field. When there is no visible label or heading for a contenteditable region, add an accessible name using the `aria-label` attribute to help screen reader users understand the purpose of the editable area.

```html
<div contenteditable="true" aria-label="Note editor">
  Editable content goes here
</div>
```

## `focus` and `blur` Events

- **`blur` event**: Fires when an element loses focus.

```js
element.addEventListener("blur", () => {
  // Handle when user leaves the element
});
```

- **`focus` event**: Fires when an element receives focus.

```js
element.addEventListener("focus", () => {
  // Handle when user enters the element
});
```

# --assignment--

Review the JavaScript and Accessibility topics and concepts.

