---
id: 671a892927fdba60db05edfe
title: Design Fundamentals Review
challengeType: 31
dashedName: review-design-fundamentals
---

# --description--

## Design Terminology

- **Layout**: This is how visual elements are arranged on a page or screen to communicate a message. These elements may include text, images, and white space.
- **Alignment**: This is how the elements are placed in relation to one another. Using alignment correctly is helpful for making the design look clean and organized.
- **Composition**: This is the act of arranging elements to create a harmonious design. It determines how elements like images, text, and shapes relate to each other and contribute to the design in an artistic way.
- **Balance**: This is how visual weight is distributed within a composition. Designers aim to create an equilibrium through symmetrical or asymmetrical arrangements.
- **Scale**: This refers to comparing the dimensions or size of one element to that of another.
- **Hierarchy**: This establishes the order of importance of the elements in a design. It's about making sure that the most important information is noticed first. 
- **Contrast**: This is the process of creating clear distinctions between the elements. You can do this through variations in color, size, shape, texture, or any other visual characteristic. Strong contrast is also helpful for improving readability.
- **White Space (negative space)**: This is the empty space in a design. It's the area surrounding the elements.
- **UI (User Interface)**: UI includes the visual and interactive elements that users can see on their screens, like icons, images, text, menus, links, and buttons.
- **UX (User Experience)**: UX is about how users feel when using a product or service. An application with a well-designed user experience is intuitive, easy to use, efficient, accessible, and enjoyable.
- **Design Brief**: This is a document that outlines the objectives, goals, and requirements of a project. It is a roadmap that guides the design process and ensures that the final product meets the needs of the client.
- **Vector Based Design**: This involves creating digital art using mathematical formulas to define lines, shapes, and colors.
- **Prototyping**: This refers to the process of creating an interactive model of a product or user interface.

## UI Design Fundamentals

- **Good Contrast for Background and Foreground Colors**: It is important to ensure that the background and foreground colors have good contrast to make the text readable. The Web Content Accessibility Guidelines (WCAG) recommend a minimum contrast ratio of 4.5:1 for normal text and 3:1 for large text.
- **Good Visual Hierarchy in Design**: A strong visual hierarchy can provide a clear path for the eye to follow, ensuring that the information you convey is consumed in the order that you intend.
- **Responsive Images**: Responsive images are images that scale to fit the size of the screen they are being viewed on. This is important because it ensures that your images look good on all devices, from desktops to mobile phones.
- **Progressive Enhancement**: This is a design approach that ensures all users, regardless of browser or device, can access the essential content and functionality of an application. 
- **User-centered Design**: This is an approach that prioritizes the end user, from their needs to their preferences and limitations. The goal of user-centered design is to craft a web page that is intuitive, efficient to use, and pleasing for your users to interact with.
- **User Research**: This is the systematic study of the people who use your product. The goal is to measure user needs, behaviors, and pain points.
- **Exit Interviews**: This is a survey you can give to users when they cancel their accounts. It can help you understand why users are leaving and what you can do to reduce churn.
- **User Testing**: This refers to the practice of capturing data from users as they interface with your application.
- **A/B Testing**: This is the process of shipping a new feature to a randomly selected subset of your user base. You can then leverage analytics data to determine if the feature is beneficial.
- **User Requirements**: This refers to the stories or rubric that your application needs to follow. User requirements might be defined by user research or industry standards. They can even be defined by stakeholder input.
- **Progressive Disclosure**: This is a design pattern used to only show users relevant content based on their current activity and hide the rest. This is done to reduce cognitive load and make the user experience more intuitive.
- **Deferred/Lazy Registration**: This is a UI design pattern that allows users to browse and interact with your application without having to register.

## Design Best Practices

- **Dark Mode**: This is a special feature on web applications where you can change the default light color scheme to a dark color scheme. You should use desaturated colors in dark mode. Desaturated colors are colors that are less intense and have a lower saturation level.
- **Breadcrumbs**: This is a navigation aid that shows the user where they are in the site's hierarchy. It is best to place breadcrumbs at the top of the page so users can easily find it. Also, you want to make sure the breadcrumbs are large enough to be easily read, but not so large that they take up too much space on the page.
- **Card Component**: Your card component should be simple in design, not visually cluttered or display too much information. For media, make sure to choose high-quality images and videos to enhance the user experience.
- **Infinite Scroll**: This is a design pattern that loads more content as the user scrolls down the page. You should consider using a load more button because it gives a user control over when they want to see more content. You can also add a back button so users have the ability to go back to the previous page without having to scroll all the way back up. 
- **Modal Dialog**: This is a type of pop-up that will display on top of existing page content. Usually the background content will have a dim color overlay in order to help the user better focus on the modal content. Also, it is always a good idea to allow the user to click outside of the modal to close it. When you use the HTML `dialog` element, you will get a lot of the functionality and accessibility benefits built in.
- **Progress Indication for Form Registration**: This is a way to show users how far they are in a process. It can be used in forms, registration, and setup processes. Your design should be simple, easy to find, and make it possible to go back to previous steps.
- **Shopping Cart**: Carts are a place for user to see what item they have already selected on an e-commerce platform. Your carts should always be visible to the user, use a common icon like a cart, bag or basket, and have a clear call-to-action button for users to proceed to checkout.

## Common Design Tools

- **Figma**: This cloud-based tool specializes in User Interface and User Experience (UI / UX) design. It enables design and development teams to collaborate from anywhere, offering built-in features including Vector-based design, automatic layout, a commenting and feedback system and more.
- **Sketch**: This is a popular design tool used for its intuitive interface and simplicity, making it ideal for developers who want to quickly create prototypes. It's also widely used by designers for tasks like creating UIs, icons, and web layouts.
- **Adobe XD**: This is a vector-based design and prototyping tool for UI/UX design, known for its seamless integration with other Adobe apps like Photoshop, Illustrator, and After Effects.
- **Canva**: This tool allows you to create a wide range of visual content, including posters, cover photos, presentations, short videos, and more. Its user-friendly and simple design makes it ideal for beginners.

# --assignment--

Review the Design Fundamentals topics and concepts.
