---
id: 671a88d636cebc5fbd407b78
title: Lists, Links, Background and Borders Review
challengeType: 31
dashedName: review-css-backgrounds-and-borders
---

# --description--

## Styling Lists

- **`line-height` Property**: This property is used to create space between lines of text. The accepted `line-height` values include the keyword `normal`, numbers, percentages and length units like the `em` unit.
- **`list-style-type` Property**: This property is used to specify the marker for a list item. Acceptable values can include a circle, disc, or decimal.
- **`list-style-position` Property**: This property is used to set the position for the list marker. The only two acceptable values are inside and outside.
- **`list-style-image` Property**: This property is used to use an image for the list item marker. A common use case is to use the `url` function with a value set to a valid image location.

## Spacing list items using `margin`

- Apart from `line-height`, margins can also be used in CSS to enhance the spacing and readability of list items.
- Margins create space outside each `li` element, allowing control over the gap between list items.
- `margin-bottom` is used to create space below each list item. For example, `margin-bottom: 10px;` will create a 10-pixel gap below each list item.

## Styling Links

- **`pseudo-class`**: This is a keyword added to a selector that allows you to select elements based on a particular state. Common states would include the `:hover`, `:visited` and `:focus` states.
- **`:link pseudo-class`**: This pseudo-class is used to style links that have not be visited by the user.
- **`:visited pseudo-class`**: This pseudo-class is used to style links where a user has already visited.
- **`:hover pseudo-class`**: This pseudo-class is used to style an elements where a user is actively hovering over them.
- **`:focus pseudo-class`**: This pseudo-class is used to style an element when it receives focus. Examples would include `input` or `select` elements where the clicks or tabs on the element to focus it.
- **`:active pseudo-class`**: This pseudo-class is used to style an element that was activated by the user. A common example would be when the user clicks on a button.

## Working with Backgrounds and Borders

- **`background-size` Property**: This property is used to set the background size for an element. Some common values include `cover` for the background image to cover the entire element and `contain` for the background image to fit within the element.
- **`background-repeat` Property**: This property is used to determine how background images should be repeated along the horizontal and vertical axes. The default value for `background-repeat` is `repeat` meaning the image will repeat both horizontally and vertically. You can also specify that there should be no repeat by using the `no-repeat` property.
- **`background-position` Property**: This property is used to specify the position of the background image. It can be set to a specific length, percentage, or keyword values like `top`, `bottom`, `left`, `right`, and `center`.
- **`background-attachment` Property**: This property is used to specify whether the background image should scroll with the content or remain fixed in place. The main values are `scroll` (default), where the background image scrolls with the content, and `fixed`, where the background image stays in the same position on the screen.
- **`background-image` Property**: This property is used to set the background image of an element. You can set multiple background images at the same time and use either the `url`, `radial-gradient` or `linear-gradient` functions as values.
- **`background` Property**: This is the shorthand property for setting all background properties in one declaration. Here is an example of setting the background image and setting it to not repeat: `background: no-repeat url("example-url-goes-here");`
- **Good Contrast for Background and Foreground Colors**: It is important to ensure that the background and foreground colors have good contrast to make the text readable. The Web Content Accessibility Guidelines (WCAG) recommend a minimum contrast ratio of 4.5:1 for normal text and 3:1 for large text.

## Borders

- **`border-top` Property**: This property is used to set the styles for the top border of an element. `border-top: 3px solid blue;` sets a 3-pixel-wide solid blue border on the top side of the element.
- **`border-right` Property**: This property is used to set the styles for the right border of an element. `border-right: 2px solid red;` sets a 2-pixel-wide solid red border on the right side of the element.
- **`border-bottom` Property**: This property is used to set the styles for the bottom border of an element. `border-bottom: 1px dashed green;` sets a 1-pixel-wide dashed green border on the bottom side of the element.
- **`border-left` Property**: This property is used to set the styles for the left border of an element. `border-left: 4px dotted orange;` sets a 4-pixel-wide dotted orange border on the left side of the element.
- **`border` Property**: This is the shorthand property for setting the width, style, and color of an element's border. `border: 1px solid black;` sets a 1-pixel-wide solid black border.
- **`border-radius` Property**: This property is used to create rounded corners for an element's border.
- **`border-style` Property**: This property is used to set the style of an element's border. Some accepted values include `solid`, `dashed`, `dotted`, and `double`.

## Gradients

- **`linear-gradient()` Function**: This CSS function is used to create a transition between multiple colors along a straight line. 
- **`radial-gradient()` Function**: This CSS function creates an image that radiates from a particular point, like a circle or an ellipse, and gradually transitions between multiple colors.

# --assignment--

Review the CSS Backgrounds and Borders topics and concepts.
