---
id: 6724e387ee098d1ef33108ba
title: Bash Commands Review
challengeType: 31
dashedName: review-bash-commands
---

# --description--

## Terminal, Shell, and Command Line Basics

- **Command line**: A text interface where users type commands.  
- **Terminal**: The application that provides access to the command line.  
- **Terminal emulator**: Adds extra features to a terminal.  
- **Shell**: Interprets the commands entered into the terminal (e.g., Bash).  
- **PowerShell / Command Prompt / Microsoft Terminal**: Options for accessing the command line on Windows.  
- **Terminal (macOS)**: Built-in option on macOS, with third-party alternatives like iTerm or Ghostty.  
- **Terminal (Linux)**: Options vary by distribution, with many third-party emulators like kitty.  
- **Terminology**: Though "terminal," "shell," and "command line" are often used interchangeably, they have specific meanings.  


## Command Line Shortcuts

- **Up/Down arrows**: Cycle through previous/next commands in history.
- **Tab**: Autocomplete commands.
- **`Control+L`** (Linux/macOS) or typing `cls` (Windows): Clear the terminal screen.
- **`Control+C`**: Interrupt a running command (also used for copying in PowerShell if text is selected).
- **`Control+Z`** (Linux/macOS only): Suspend a task to the background; use `fg` to resume it.
- **`!!`**: Instantly rerun the last executed command.

## Bash Basics

- **Bash** (Bourne Again Shell): Widely used Unix-like shell.  
  Key commands:

  - **`pwd`**: Show the current directory.
  - **`cd`**: Change directories.
    - **`..`** refers to the parent directory (one level up).
    - **`.`** refers to the current directory.
  - **`ls`**: List files and folders.
    - **`-a`**: Show all files, including hidden files.
    - **`-l`**: Show detailed information about files.
  - **`less`**: View file contents one page at a time with navigation options, including scrolling backward and searching.
  - **`more`**: Display file contents one screen at a time, with limited backward scrolling and basic navigation.
  - **`cat`**: Show the entire file content at once without scrolling or navigation, useful for smaller files.
  - **`mkdir`**: Create a new directory.
  - **`rmdir`**: Remove an empty directory.
  - **`touch`**: Create a new file.
  - **`mv`**: Move or rename files.
    - Rename: `mv oldname.txt newname.txt`
    - Move: `mv filename.txt /path/to/target/`
  - **`cp`**: Copy files.
    - **`-r`**: Recursively copy directories and their contents.
  - **`rm`**: Delete files.
    - **`-r`**: Recursively delete directories and their contents.
  - **`echo`**: Display a line of text or a variable's value.
    - Use `>` to overwrite the existing content in a file. (e.g., `echo "text" > file.txt`)
    - Use `>>` to append output to a file **without overwriting existing content** (e.g., `echo "text" >> file.txt`).
  - **`exit`**: Exit the terminal session.
  - **`clear`**: Clear the terminal screen.
  - **`find`**: Search for files and directories.
    - **`-name`**: Search for files by name pattern (e.g., `find . -name "*.txt"`).
  - Use **`man`** followed by a command (e.g., `man ls`) to access detailed manual/help pages.

## Command Options and Flags

- **Options** or **flags**: modify a command's behavior and are usually prefixed with hyphens:
  - **Long form (two hyphens)**:  
    - Example: `--help`, `--version`
    - Values are attached using an equals sign, e.g., `--width=50`.
  - **Short form (one hyphen)**:  
    - Example: `-a`, `-l`
    - Values are passed with a space, e.g., `-w 50`.
    - Multiple short options can be chained together, e.g., `ls -alh`.
- **`--help`**: You can always use a command with this flag to understand the available options for any command.

# --assignment--

Review the Bash Commands topics and concepts.
