---
id: 66f1af82732957c895f0b21a
title: SQL and PostgreSQL Quiz
challengeType: 8
dashedName: quiz-sql-and-postgresql
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is a relational database?

#### --distractors--

A database structured to recognize non-relation between stored items.

---

A database that stores unstructured data.

---

A flat file-based system.

#### --answer--

A database structured to recognize and manage relationships between data in tables.

### --question--

#### --text--

How does a non-relational database differ from a relational database?

#### --distractors--

Non-relational databases use tables, while relational databases do not.

---

Relational databases can store unstructured data.

---

Non-relational databases are slower than relational databases.

#### --answer--

Non-relational databases can store unstructured data.

### --question--

#### --text--

What does the `\l` command do when executed in the PostgreSQL interactive terminal (`psql`)?

#### --distractors--

Lists all schemas.

---

Lists all tables.

---

Connects to a database.

#### --answer--

Lists all databases.

### --question--

#### --text--

Which of the following commands creates a new table in SQL?

#### --distractors--

`ADD TABLE`

---

`NEW TABLE`

---

`ALTER TABLE`

#### --answer--

`CREATE TABLE`

### --question--

#### --text--

What is the purpose of a foreign key in a relational database?

#### --distractors--

To allow duplication of data.

---

To uniquely identify a row in the table.

---

To store large amounts of text data.

#### --answer--

To create a relationship between two tables.

### --question--

#### --text--

Which command will add a new column to an existing table?

#### --distractors--

`ADD COLUMN column_name TO table_name data_type;`

---

`INSERT COLUMN column_name INTO table_name data_type;`

---

`MODIFY TABLE table_name ADD COLUMN column_name data_type;`

#### --answer--

`ALTER TABLE table_name ADD COLUMN column_name data_type;`

### --question--

#### --text--

What type of relationship exists when one record in Table A corresponds to one or more records in Table B?

#### --distractors--

One-to-One (1-1)

---

Many-to-Many (m-m)

---

Many-to-one(m-1)

#### --answer--

One-to-Many (1-m)

### --question--

#### --text--

What is a query?

#### --distractors--

A request to remove all data from the database.

---

A special row for unique values in a database.

---

A special column for unique values in a database.

#### --answer--

A request for specific data from the database.

### --question--

#### --text--

How do you delete a column from a table in SQL?

#### --distractors--

`REMOVE COLUMN column_name FROM table_name;`

---

`DELETE COLUMN column_name FROM table_name;`

---

`MODIFY TABLE table_name DELETE column_name;`

#### --answer--

`ALTER TABLE table_name DROP COLUMN column_name;`

### --question--

#### --text--

What is the function of the `PRIMARY KEY` constraint in SQL?

#### --distractors--

To link two tables together.

---

To define the default value for a column.

---

To allow null values in the column.

#### --answer--

To ensure that the column contains unique values.

### --question--

#### --text--

What does the command `\c` do in the PostgreSQL interactive terminal (`psql`)?

#### --distractors--

Lists all tables in the current database.

---

Displays the current database connection details.

---

Exits the `psql` shell.

#### --answer--

Connects to the specified database.

### --question--

#### --text--

What is a composite key in a relational database?

#### --distractors--

A key that is derived from another key.

---

A key that changes frequently based on data updates.

---

A key used exclusively for foreign key relationships.

#### --answer--

A key that is composed of multiple columns to uniquely identify a record.

### --question--

#### --text--

Which command inserts data into a table?

#### --distractors--

`PUT VALUES`

---

`UPDATE INTO`

---

`ADD DATA`

#### --answer--

`INSERT INTO`

### --question--

#### --text--

How do you rename a column in SQL?

#### --distractors--

`MODIFY COLUMN`

---

`CHANGE COLUMN`

---

`ALTER COLUMN`

#### --answer--

`RENAME COLUMN`

### --question--

#### --text--

Which query will delete all records from the employees table?

#### --distractors--

`REMOVE ALL`

---

`TRUNCATE employees`

---

`DROP RECORDS`

#### --answer--

`DELETE FROM employees`

### --question--

#### --text--

Which SQL constraint specifically ensures that a column can contain only unique values, allowing nulls?

#### --distractors--

`NOT NULL`

---

`FOREIGN KEY`

---

`PRIMARY KEY`

#### --answer--

`UNIQUE`

### --question--

#### --text--

Which of the following is NOT an example of a commonly used relational database in the industry?

#### --distractors--

MySQL

---

SQLite

---

PostgreSQL

#### --answer--

SQLQuery

### --question--

#### --text--

What does a one-to-one (1-1) relationship represent in a relational database?

#### --distractors--

Each record in Table A corresponds to one or more records in Table B.

---

Each record in Table A corresponds to no records in Table B.

---

Each record in Table A corresponds to multiple records in Table B and vice versa.

#### --answer--

Each record in Table A corresponds to exactly one record in Table B.

### --question--

#### --text--

What command will list all tables in the current PostgreSQL database?

#### --distractors--

`\l`

---

`SHOW TABLES`

---

`\t`

#### --answer--

`\d`

### --question--

#### --text--

Which of the following allows you to join a table with itself?

#### --distractors--

`LEFT OUTER JOIN`

---

`CROSS JOIN`

---

`RIGHT OUTER JOIN`

#### --answer--

`SELF JOIN`


