---
id: 66edd3f9bef926f129990425
title: Local Storage and CRUD Quiz
challengeType: 8
dashedName: quiz-local-storage-and-crud
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What does CRUD stand for in the context of web development?

#### --distractors--

Create, Replace, Undo, Delete.

---

Connect, Remove, Update, Display.

---

Copy, Retrieve, Update, Delete.

#### --answer--

Create, Read, Update, Delete.

### --question--

#### --text--

Which HTTP method is commonly associated with the Create operation in a RESTful API?

#### --distractors--

`GET`

---

`PUT`

---

`DELETE`

#### --answer--

`POST`

### --question--

#### --text--

Which of the following CRUD operations is typically performed when modifying an existing record in a database?

#### --distractors--

Read

---

Delete

---

Create

#### --answer--

Update

### --question--

#### --text--

What is the main difference between localStorage and sessionStorage in the Web Storage API?

#### --distractors--

localStorage stores data in memory, while sessionStorage stores data on the disk.

---

sessionStorage is faster than localStorage for retrieving data.

---

localStorage data is only available during a session, while sessionStorage persists across sessions.

#### --answer--

localStorage data persists until explicitly deleted, while sessionStorage data is cleared when the page session ends.

### --question--

#### --text--

Which method is used to store data in localStorage?

#### --distractors--

`localStorage.setData()`

---

`localStorage.saveItem()`

---

`localStorage.storeData()`

#### --answer--

`localStorage.setItem()`

### --question--

#### --text--

How can you remove a single item from sessionStorage?

#### --distractors--

`sessionStorage.clearItem('key')`

---

`sessionStorage.remove('key')`

---

`sessionStorage.deleteItem('key')`

#### --answer--

`sessionStorage.removeItem('key')`

### --question--

#### --text--

What is the difference between `PUT` and `PATCH`?

#### --distractors--

`PUT` modifies specific fields, while `PATCH` replaces the entire resource.

---

`PUT` only adds new resources, while `PATCH` updates existing ones.

---

`PUT` is used for retrieving data, while `PATCH` is used for sending data.

#### --answer--

`PUT` replaces the entire resource, while `PATCH` updates specific fields.

### --question--

#### --text--

What is the cache storage used for?

#### --distractors--

Cache storage is used to permanently store user credentials securely in the browser for authentication purposes.

---

Cache storage is used to store large volumes of structured data in the browser using a database system.

---

Cache storage is used to track user sessions and preferences by storing key-value pairs accessible across multiple websites.

#### --answer--

Cache storage is used to store frequently requested network resources, reducing load times and improving performance.

### --question--

#### --text--

What is a cookie in the context of web development?

#### --distractors--

A type of HTTP request.

---

A piece of code that runs in the browser.

---

A method to store large files on a server.

#### --answer--

A small piece of data stored by the user's web browser.

### --question--

#### --text--

Which of the following methods is used to manually set a cookie in JavaScript?

#### --distractors--

`document.setCookie`

---

`document.cookie.set`

---

`document.createCookie`

#### --answer--

`document.cookie`

### --question--

#### --text--

Which of the following code snippets correctly deletes a cookie named `username`?

#### --distractors--

`document.cookie.delete("username");`

---

`document.removeCookie("username");`

---

`cookie.delete("username");`

#### --answer--

`document.cookie = "username=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";`

### --question--

#### --text--

Which of the following statements about cookies is false?

#### --distractors--

Session cookies expire when the browser is closed.

---

HttpOnly cookies cannot be accessed by JavaScript.

---

Secure cookies are only transmitted over HTTPS.

#### --answer--

Cookies can only be set by the server.

### --question--

#### --text--

What is browser fingerprinting?

#### --distractors--

A technique used in identifying users based on their IP address.

---

A form of data encryption.

---

A method of storing data in the browser's cache.

#### --answer--

A way of tracking users through browser and device attributes.

### --question--

#### --text--

What is a primary risk associated with storing passwords in local storage?

#### --distractors--

Local storage data is deleted once you close the browser tab.

---

Local storage data is lost once you delete cookies.

---

Local storage doesn't work offline.

#### --answer--

Local storage is not encrypted and can be accessed easily.

### --question--

#### --text--

What of the following statements is true about client-side storage?

#### --distractors--

Client-side storage uses objects instead of strings to store data.

---

Client-side storage uses cloud services to sync user data across multiple devices.

---

Client-side storage is more secure than server-side storage.

#### --answer--

Client-side storage allows websites to store data on a user's device.

### --question--

#### --text--

What is the primary benefit of using IndexedDB over localStorage?

#### --distractors--

IndexedDB does not require user consent for data storage.

---

IndexedDB has a simpler API.

---

IndexedDB is supported in all web browsers.

#### --answer--

IndexedDB can handle larger amounts of data and more complex queries.

### --question--

#### --text--

Which of the following is a valid way to retrieve data from an object store in IndexedDB?

#### --distractors--

Calling `retrieve()` on the object store.

---

Using `query()` to access specific records.

---

Using `fetch()` method.

#### --answer--

Using `get()` on the store reference.

### --question--

#### --text--

What type of transactions does IndexedDB support?

#### --distractors--

Read transactions only.

---

Asynchronous transactions only.

---

Synchronous transactions only.

#### --answer--

Read and write transactions.

### --question--

#### --text--

Which of the following is true about the lifecycle of a Service Worker?

#### --distractors--

Service Workers run in the main thread of the web application.

---

Service Workers can be activated before they are installed.

---

Service Workers can only run when the web application is open in the browser.

#### --answer--

A Service Worker can intercept network requests after it has been activated.

### --question--

#### --text--

Which statement best describes a key feature of Progressive Web Apps (PWAs)?

#### --distractors--

PWAs can only be installed on mobile devices.

---

PWAs are required to have a backend server.

---

PWAs can only be accessed through specific browsers.

#### --answer--

PWAs provide offline functionality through Service Workers.

