---
id: 67358be1c7903489c0a7db78
title: JavaScript Maps and Sets Quiz
challengeType: 8
dashedName: quiz-javascript-maps-and-sets
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is a Set in JavaScript?

#### --distractors--

A data structure that allows duplicate values.

---

A data structure that only stores strings and numbers.

---

A collection that does not allow deletion of its elements.

#### --answer--

A collection in which a value can only occur once.

### --question--

#### --text--

Which of the following methods is available in Maps but not in Sets?

#### --distractors--

`has()`

---

`clear()`

---

`values()`

#### --answer--

`set()`

### --question--

#### --text--

What method is used to add elements to a Set?

#### --distractors--

`.push()`

---

`.append()`

---

`.insert()`

#### --answer--

`.add()`

### --question--

#### --text--

How do you check if a Set contains a certain value?

#### --distractors--

`.contains()`

---

`.hasValue()`

---

`.find()`

#### --answer--

`.has()`

### --question--

#### --text--

Which of these is a great use case for Sets?

#### --distractors--

Managing key-value pairs in a database.

---

Creating ordered lists of items.

---

Storing hierarchical data structures in the browser local storage.

#### --answer--

Eliminating duplicates from an array.

### --question--

#### --text--

What is a WeakSet in JavaScript?

#### --distractors--

A Set-like collection that only allows primitive data types.

---

A Set-like collection that allows duplicate values.

---

A Set-like collection that prevents values from being removed.

#### --answer--

A Set-like collection that only stores objects.

### --question--

#### --text--

What is one difference between a Set and a WeakSet?

#### --distractors--

A WeakSet can store any type of value, including numbers.

---

A Set does not allow duplicate values, but a WeakSet does.

---

A Set allows garbage collection, whereas a WeakSet does not.

#### --answer--

A Set can hold any type of value, while a WeakSet only holds objects.

### --question--

#### --text--

What is a Map in JavaScript?

#### --distractors--

A collection that only allows unique values.

---

A collection that can only use strings as keys.

---

A collection that does not allow deletion of its items.

#### --answer--

A collection of key-value pairs of any type.

### --question--

#### --text--

What method is used to insert key-value pairs into a Map?

#### --distractors--

`.append()`

---

`.add()`

---

`.insert()`

#### --answer--

`.set()`

### --question--

#### --text--

What will the following code output?

```js
const myMap = new Map();
myMap.set('a', 1);
myMap.set('a', 2);
console.log(myMap.get('a'));
```

#### --distractors--

`1`

---

`undefined`

---

`null`

#### --answer--

`2`

### --question--

#### --text--

How does a Map differ from an Object in JavaScript?

#### --distractors--

A Map only allows numbers as keys.

---

Objects allow any type as keys, while Maps only allow strings.

---

Maps do not support iteration, while Objects do.

#### --answer--

Maps allow any type of key, but Objects only allow strings and symbols.

### --question--

#### --text--

How can you remove a key-value pair from a Map?

#### --distractors--

`.remove()`

---

`.deleteKey()`

---

`.erase()`

#### --answer--

`.delete()`

### --question--

#### --text--

What does the `size` property of a Map return?

#### --distractors--

The number of indexes in the Map.

---

The number of unique values in the Map.

---

The total memory used by the Map.

#### --answer--

The number of key-value pairs in the Map.

### --question--

#### --text--

What is a WeakMap in JavaScript?

#### --distractors--

A Map-like collection that allows primitive values as keys.

---

A Map-like collection that blocks the deletion of items.

---

A Map-like collection that automatically sorts its keys.

#### --answer--

A Map-like collection with weak references to the keys.

### --question--

#### --text--

What is one difference between a Map and a WeakMap?

#### --distractors--

A Map allows only primitive types as keys, whereas a WeakMap only allows objects.

---

A Map allows garbage collection, whereas a WeakMap does not.

---

A WeakMap allows duplicate keys, whereas a Map does not.

#### --answer--

A Map is iterable, whereas a WeakMap is not.

### --question--

#### --text--

Which of the following methods does NOT exist on a WeakMap?

#### --distractors--

`.has()`

---

`.set()`

---

`.delete()`

#### --answer--

`.size()`

### --question--

#### --text--

What will be the output of the following code?

```js
const set = new Set([1, 2, 3]);
set.delete(2);
console.log(set.has(2));
```

#### --distractors--

`true`

---

`undefined`

---

`2`

#### --answer--

`false`

### --question--

#### --text--

How can you iterate over the values in a Set?

#### --distractors--

By using the `.map()` method.

---

By using the `.reduce()` method.

---

By using the `.filter()` method.

#### --answer--

By using the `.forEach()` method.

### --question--

#### --text--

Which two methods of Sets return a `SetIterator` that contains the values of a certain Set?

#### --distractors--

`entries()` and `values()`

---

`forEach()` and `values()`

---

`has()` and `add()`

#### --answer--

`keys()` and `values()`

### --question--

#### --text--

What will be the output of the following code?

```js
const map = new Map([["a", 1], ["b", 2]]);
map.clear();
console.log(map.size);
```

#### --distractors--

`2`

---

`1`

---

`undefined`

#### --answer--

`0`
