---
id: 66edcd875b0d91de1fbbb492
title: JavaScript Fundamentals Quiz
challengeType: 8
dashedName: quiz-javascript-fundamentals
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

Which one of these will create a String object?

#### --distractors--

```js
String({ "Hello World" });
```

---

```js
String("Hello World");
```

---

```js
"Hello World".toString();
```

#### --answer--

```js
new String("Hello World");
```

### --question--

#### --text--

How can you convert a String object into a string literal?

#### --distractors--

With the `String()` constructor.

---

With the `.stringify()` method.

---

Enclose the `String` object in double quotes.

#### --answer--

With the `.toString()` method.

### --question--

#### --text--

Why can you use methods like `.length`, `.repeat()`, `.concat()`, and `.slice()` on a string primitive in JavaScript?

#### --distractors--

Those methods exist natively on string primitives.

---

String primitives are stored as objects internally.

---

JavaScript temporarily converts the string primitive to an array.

#### --answer--

JavaScript temporarily wraps the string primitive in a String object.

### --question--

#### --text--

What will the following code log to the console?

```js
let stringArray = [8, 9, 10].toString();
console.log(stringArray);
```

#### --distractors--

`[8,9,10]`

---

`["8", "9", "10"]`

---

`"8", "9", "10"`

#### --answer--

`"8,9,10"`

### --question--

#### --text--

How can you convert a string literal into a Number object?

#### --distractors--

With the `Object()` constructor.

---

With the `.toNumber()` method.

---

With the `.parseInt()` method.

#### --answer--

With the `Number()` constructor.

### --question--

#### --text--

What will `Number(true)` and `Number(false)` return, respectively?

#### --distractors--

`undefined` and `undefined`

---

`NaN` and `NaN`

---

`true` and `false`

#### --answer--

`1` and `0`

### --question--

#### --text--

What will `Number(undefined)` and `Number(null)` return, respectively?

#### --distractors--

`NaN` and `NaN`

---

`0` and `0`

---

`undefined` and `null`

#### --answer--

`NaN` and `0`

### --question--

#### --text--

Which of the following is the best name for a boolean variable that checks if a user is allowed to do something on your website?

#### --distractors--

`getPermission`

---

`handlePermission`

---

`permission`

#### --answer--

`hasPermission`

### --question--

#### --text--

Which of the following is the best name for a function that runs when a user submits a form?

#### --distractors--

`hasSubmitted`

---

`formSubmit`

---

`didSubmit`

#### --answer--

`handleSubmit`

### --question--

#### --text--

What is a sparse array?

#### --distractors--

An array where one or more indices have a value of `null`.

---

An array where one or more indices have a value of `undefined`.

---

An array where one or more indices have a value of an empty object literal.

#### --answer--

An array where one or more indices are not assigned a value.

### --question--

#### --text--

In which of the following examples will `arr` NOT be a sparse array?

#### --distractors--

```js
const arr = new Array(5);
```

---

```js
const arr = [1, 2, 3];
arr[4] = 4;
```

---

```js
const arr = [1, 2, 3, , 5];
```

#### --answer--

```js
const arr = Array.from({ length: 5 });
```

### --question--

#### --text--

What is the primary purpose of a linter?

#### --distractors--

To format code automatically.

---

To optimize code for performance.

---

To create documentation for code.

#### --answer--

To detect potential errors and issues in code.

### --question--

#### --text--

What is a benefit of using a formatter in a codebase?

#### --distractors--

They allow developers to compile code more efficiently.

---

They convert code to a specific programming language.

---

They detect logical errors.

#### --answer--

They ensure a consistent code style.

### --question--

#### --text--

In JavaScript, who or what is typically responsible for allocating memory to variables?

#### --distractors--

The developer.

---

The operating system.

---

The server.

#### --answer--

The runtime engine.

### --question--

#### --text--

What will be logged to the console in the following code?

```js
function trackTotal(initialValue) {
  let total = initialValue;
  return function(increment) {
    total += increment;
    return total;
  };
}

let track = trackTotal(1);
console.log(track(2));
console.log(track(3));
```

#### --distractors--

```js
2
5
```

---

```js
2
3
```

---

```js
5
6
```

#### --answer--

```js
3
6
```

### --question--

#### --text--

What is hoisting in JavaScript?

#### --distractors--

Raising errors to the top of the code.

---

The process of creating new variables.

---

Automatically moving `var` declarations to the top of the block.

#### --answer--

The process of moving variable declarations to the top of their scope.

### --question--

#### --text--

Why is using the `var` keyword considered bad practice in modern JavaScript?

#### --distractors--

They're slower than `let` and `const`.

---

They cause syntax errors.

---

They don't allow type checking.

#### --answer--

They're accessible outside their block.

### --question--

#### --text--

What is the purpose of modules in JavaScript?

#### --distractors--

To improve code performance.

---

To make code more difficult to understand.

---

To create new programming languages.

#### --answer--

To organize code into reusable units.

### --question--

#### --text--

How do you add an `app.js` script as a module in an HTML document?

#### --distractors--

```html
<script type="module/javascript" src="app.js"></script>
```

---

```html
<script src="app.js"></script>
```

---

```html
<script src="app.js" module></script>
```

#### --answer--

```html
<script type="module" src="app.js"></script>
```

### --question--

#### --text--

Which of the following examples exports the `calculateSum` function from a `utils.js` module and properly imports and uses it in an `app.js` file?

#### --distractors--

```js
// utils.js
export default function calculateSum(a, b) {
  return a + b;
}

// app.js
import { calculateSum } from './utils.js';
console.log(calculateSum(2, 3));
```

---

```js
// utils.js
export function calculateSum(a, b) {
  return a + b;
}

// app.js
import calculateSum from './utils.js';
console.log(calculateSum(2, 3));
```

---

```js
// utils.js
function calculateSum(a, b) {
  return a + b;
}

export default calculateSum;

// app.js
import * as utils from './utils.js';
console.log(utils.calculateSum(2, 3));
```

#### --answer--

```js
// utils.js
export function calculateSum(a, b) {
  return a + b;
}

// app.js
import { calculateSum } from './utils.js';
console.log(calculateSum(2, 3));
```
