---
id: 66edcc779993c0da6906dbb9
title: JavaScript Functions Quiz
challengeType: 8
dashedName: quiz-javascript-functions
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

Which of the following is the correct way to declare a function in JavaScript?

#### --distractors--

```js
func greet() {
  console.log("Hello there!");
}
```

---

```js
defineFunction greet() {
  console.log("Hello there!");
}
```

---

```js
def greet() {
  console.log("Hello there!");
}
```

#### --answer--

```js
function greet() {
  console.log("Hello there!");
}
```

### --question--

#### --text--

What happens when you call (or execute) a function?

#### --distractors--

The code inside the function will run and `null` will always be returned.

---

Nothing will happen when you call a function.

---

A `TypeError` will be thrown and the program will crash.

#### --answer--

The code inside the function will run and a value will be returned.

### --question--

#### --text--

Which of the following is the correct way to call a function?

#### --distractors--

```js
exampleFunction;
```

---

```js
exampleFunction>>;
```

---

```js
()exampleFunction();
```

#### --answer--

```js
exampleFunction();
```

### --question--

#### --text--

What is the role of the `return` keyword?

#### --distractors--

The `return` keyword will execute the function.

---

The `return` keyword will throw a type error.

---

The `return` keyword serves no purpose in functions.

#### --answer--

The `return` keyword returns a value from the function.

### --question--

#### --text--

Which of the following is a valid function expression?

#### --distractors--

```js
expression function getSum(x, y) {
    return x + y;
};
```

---

```js
getSum: function(x, y) {
    return x + y;
};
```

---

```js
function = getSum(x, y) {
    return x + y;
};
```

#### --answer--

```js
const getSum = function(x, y) {
    return x + y;
};
```

### --question--

#### --text--

What are function arguments?

#### --distractors--

Values that represents the absence of a value.

---

Special values that act similar to anonymous functions.

---

Placeholder values used inside of the function.

#### --answer--

Real values passed to a function when it is called.

### --question--

#### --text--

What are function parameters?

#### --distractors--

Floating point values used inside of the function.

---

Values passed to a function when it is called.

---

Values that represent the intentional absence of the value.

#### --answer--

Values listed inside the function definition.

### --question--

#### --text--

What will be logged to the console?

```js
const calculateTotal = (amount, taxRate = 0.05) => {
  return amount + (amount * taxRate);
};

console.log(calculateTotal(100));
```

#### --distractors--

`10`

---

`undefined`

---

`1`

#### --answer--

`105`

### --question--

#### --text--

Which of the following is the correct syntax for an arrow function?

#### --distractors--

```js
const sum <<>> (num1, num2) => num1 + num2
```

---

```js
const sum === (num1, num2) === num1 + num2
```

---

```js
const sum >=> (num1, num2) => num1 + num2
```

#### --answer--

```js
const sum = (num1, num2) => num1 + num2
```

### --question--

#### --text--

What will be result for the following code?

```js
function greet() {
  const developer = "Jessica";
  console.log("Hello there!");
}

console.log(developer);
```

#### --distractors--

Nothing will happen and the code will run normally.

---

The string `"Hello there!"` will be logged to the console.

---

The string `"Hello!"` will be logged to the console.

#### --answer--

You will get a reference error because `developer` is not defined globally.

### --question--

#### --text--

When can you omit a set of parentheses around a parameter list for an arrow function?

#### --distractors--

You should always omit the parentheses around a parameter list.

---

You are never supposed to omit the parentheses for an arrow function.

---

You should only omit the parentheses when you are working with multiple parameters.

#### --answer--

You should only omit the parentheses when you only have one parameter.

### --question--

#### --text--

When can you omit the curly braces and `return` keyword for an arrow function?

#### --distractors--

You should always omit the curly braces and `return` keyword.

---

You should never omit the curly braces and `return` keyword.

---

When the function body has multiple lines of code.

#### --answer--

When the function body consists of a single expression.

### --question--

#### --text--

What will the following function return?

```js
function exampleFunction() {
  return "Hello";
  return "World!";
};
```

#### --distractors--

`"World!"`

---

`"Hello World!"`

---

`undefined`

#### --answer--

`"Hello"`

### --question--

#### --text--

Which of the following is the correct way to use default parameters?

#### --distractors--

```js
function sum(num1, num2 <<>> 12) {
  return num1 + num2
}
```

---

```js
function sum(num1, num2 === 12) {
  return num1 + num2
}
```

---

```js
function sum(num1, num2 >> 12) {
  return num1 + num2
}
```

#### --answer--

```js
function sum(num1, num2 = 12) {
  return num1 + num2
}
```

### --question--

#### --text--

What will be the result for the following code?

```js
const developer = "Jessica";

function greet() {
  console.log("Hello, " + developer)
}

greet();
```

#### --distractors--

The string `"Hello, developer"` will be logged to the console.

---

An error message will display in the console.

---

Nothing will display in the console.

#### --answer--

The string `"Hello, Jessica"` will be logged to the console.

### --question--

#### --text--

What happens if you try to remove the curly braces for a regular function?

#### --distractors--

An alert box will display on the page with an error.

---

The program will crash and not start again.

---

Nothing will happen.

#### --answer--

You will get a syntax error.

### --question--

#### --text--

What will be the result for the following code?

```js
const sum = (num1, num2) => num1 + num2
console.log(sum(0, 0) + 10);
```

#### --distractors--

An error message will display in the console.

---

The number `0` will be logged to the console.

---

Nothing will be logged to the console.

#### --answer--

The number `10` will be logged to the console.

### --question--

#### --text--

What will be the output for the following code?

```js
const exampleFunction = (param1, param2) => param1 + param2;
console.log(exampleFunction(3, "Something"));
```

#### --distractors--

`null`

---

`undefined`

---

`3 + "Something"`

#### --answer--

`"3Something"`

### --question--

#### --text--

What will be the result for the following code?

```js
const sum = (num1, num2) => num1 + num2
console.log(sum(0, 0) + num2);
```

#### --distractors--

An error message saying `num1` is not defined.

---

The number `0` will be displayed in the console.

---

`undefined` will be displayed in the console.

#### --answer--

An error message saying `num2` is not defined.

### --question--

#### --text--

What will be the output for the following code?

```js
const divideTwoNumbers = (num1, num2) => num1 / num2;
console.log(divideTwoNumbers(3, 0));
```

#### --distractors--

`Error`

---

`0`

---

`null`

#### --answer--

`Infinity`

