---
id: 66ed901ff45ce3ece4053eba
title: Design Fundamentals Quiz
challengeType: 8
dashedName: quiz-design-fundamentals
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What are some reasons why whitespace is important for good design?

#### --distractors--

Improves readability by placing many elements on the page.

---

Focuses the viewer's attention by having elements placed close together.

---

Creates breathing space in the design to make users scroll for more information.

#### --answer--

Creates visual hierarchy, improves readability, focuses the viewer's attention on different elements.

### --question--

#### --text--

What is the design principle of carefully choosing the size of elements in relation to each other?

#### --distractors--

Visual hierarchy.

---

Proportion

---

Balance

#### --answer--

Scale

### --question--

#### --text--

Which of the following sites would most likely benefit from using breadcrumbs?

#### --distractors--

A single-page portfolio site.

---

An infinite scroll gallery site.

---

A simple blog with only a few posts.

#### --answer--

A complex e-commerce site with multiple categories and subcategories.

### --question--

#### --text--

Which design pattern allows users to access and interact with elements and content on a website without requiring immediate registration?

#### --distractors--

Captcha validation.

---

Lazy loading.

---

Progressive enhancement.

#### --answer--

Deferred/lazy registration.

### --question--

#### --text--

What are three types of text alignment?

#### --distractors--

Top, center, horizontal.

---

Left, right, middle.

---

Vertical, horizontal, equal.

#### --answer--

Left, right, center.

### --question--

#### --text--

Which interaction design pattern reduces the complexity of interaction by hiding parts of interfaces progressively so that content is only introduced to the user as they progress through the application?

#### --distractors--

Extended discoverability.

---

Delayed implementation.

---

Gradual engagement.

#### --answer--

Progressive disclosure.

### --question--

#### --text--

What is contrast in design?

#### --distractors--

Elements that are visually similar.

---

The difference in saturation between two colors.

---

Matching elements on a page.

#### --answer--

Elements that are strikingly different from each other visually.

### --question--

#### --text--

Which of the following is an example of visual hierarchy in design?

#### --distractors--

Headline and title text are a similar color to the background and other elements to blend in.

---

Text and images are all the same size on the page.

---

The logo banner is smaller than all the minor images on the main landing page.

#### --answer--

Making the headline of the page larger than other text that comprise the body or sub-headings

### --question--

#### --text--

What is a common goal of conducting exit interviews in user research?

#### --distractors--

To increase the number of new users.

---

To test new features with existing users.

---

To gather data for A/B testing.

#### --answer--

To understand the factors causing user churn.

### --question--

#### --text--

What is user centered design?

#### --distractors--

A design process where once the design is completed, designers test the product by getting user feedback.

---

A design process where designers consider user accessibility requirements.

---

A design process focused on client requirements at every stage of the process.

#### --answer--

An iterative design process where designers design a product considering user requirements at every stage of the process.

### --question--

#### --text--

What is the minimum required contrast ratio for regular text for accessibility according to WCAG guidelines?

#### --distractors--

1:1

---

7:1

---

3:1

#### --answer--

4.5:1

### --question--

#### --text--

What are some colors to consider when designing dark mode?

#### --distractors--

Pure white.

---

Highly saturated colors.

---

Bright highly contrasting colors.

#### --answer--

Dark colors and muted light colors for contrast in dim lighting conditions.

### --question--

#### --text--

How can user research impact user requirements?

#### --distractors--

It has no impact on user requirements.

---

It only affects non-functional requirements.

---

It only affects functional requirements.

#### --answer--

It can help define and refine user requirements based on user feedback.

### --question--

#### --text--

Why is it important for a design brief to be reviewed and approved by all stakeholders before the project begins?

#### --distractors--

To ensure everyone is aware of the project's social media strategy.

---

To finalize the color palette and design elements.

---

To determine the project's marketing budget.

#### --answer--

To confirm that all stakeholders agree on the project's objectives and requirements.

### --question--

#### --text--

What is considered bad practice when implementing infinite scroll?

#### --distractors--

Allowing users to jump to a page or section through the navbar or a pagination drop down menu.

---

Adding a load more indicator or symbol after a certain point in the page along with the infinite scroll.

---

Integrating a footer reveal at the bottom.

#### --answer--

Not adding alternative methods of navigating the page.

### --question--

#### --text--

Which of the following is a best practice when designing progress indicators for forms?

#### --distractors--

Requiring users to restart the form if they navigate away from the page.

---

Keeping the progress indicator small and discreet.

---

Making sure the progress is just displayed visually without any text.

#### --answer--

Breaking the progress indicator into labeled sections.

### --question--

#### --text--

What is one way to make shopping cart design intuitive and user friendly?

#### --distractors--

Use a new shopping cart icon that no other website has used before.

---

Do not allow users to add or remove items from the cart.

---

Automatically add products to the cart without user interaction.

#### --answer--

Include thumbnail images of products in the cart.

### --question--

#### --text--

Dark mode doesn't mean pure black. What is a good technique to create an effective dark mode color scheme?

#### --distractors--

Make images and elements darker and reduce contrast between different elements to have them blend in.

---

Invert the color scheme.

---

Use many saturated colors.

#### --answer--

Use dark gray or a dark shade of the brand color instead of pure black.

### --question--

#### --text--

What is one good design practice when creating modals?

#### --distractors--

Put a lot of important information inside a modal.

---

Have multiple modals on the same screen.

---

Ensure the modal draws the user's attention away from it.

#### --answer--

Make the modal dismiss icon visible.

### --question--

#### --text--

What is a design brief?

#### --distractors--

A document outlining the programming and design standards of the project.

---

A document explaining how to replicate a design.

---

A document with detailed information of icons, colors, and assets the designer should use.

#### --answer--

A document stating the goals and project scope, budget and design requirements.

## --quiz--

### --question--

#### --text--

Which design tool is especially known for real-time collaboration in the cloud?

#### --distractors--

Adobe XD

---

Sketch

---

Canva

#### --answer--

Figma

### --question--

#### --text--

Which tool is most suitable for beginners creating posters and presentations?

#### --distractors--

Sketch

---

Figma

---

Adobe XD

#### --answer--

Canva

### --question--

#### --text--

Why should breadcrumbs be designed to be easily readable but not oversized?

#### --distractors--

To match the font size of main headers.

---

To keep them consistent across all screen sizes.

---

To make them blend into the background.

#### --answer--

To balance visibility without overwhelming the page layout.

### --question--

#### --text--

What is a common mistake to avoid in card component design?

#### --distractors--

Keeping the card visually simple.

---

Adding hover animations for feedback.

---

Using white space effectively.

#### --answer--

Displaying too much information at once.

### --question--

#### --text--

What usability issue can arise with infinite scroll without a "back" option?

#### --distractors--

Users may load duplicate content.

---

Users may scroll too fast.

---

Users may exit the app accidentally.

#### --answer--

Users may lose their original context.

### --question--

#### --text--

Which of the following helps visually distinguish a modal from the page content behind it?

#### --distractors--

Adding a shadow to modal buttons.

---

Animating the modal with a fade-in effect.

---

Increasing modal font size significantly.

#### --answer--

Using a dim overlay on the background content.

### --question--

#### --text--

Why should a progress indicator in a registration form support backward navigation?

#### --distractors--

It reduces loading time.

---

It makes the form look shorter.

---

It avoids page refreshes.

#### --answer--

It improves usability.

### --question--

#### --text--

When using progressive enhancement, what's the primary benefit for users on older devices or browsers?

#### --distractors--

They get alerted to upgrade their browser.

---

They are redirected to mobile-optimized sites.

---

They see a basic version of animations.

#### --answer--

They can still access essential content and features.

### --question--

#### --text--

Why might deferred (lazy) registration improve conversion rates?

#### --distractors--

It reduces backend authentication load.

---

It hides premium features.

---

It requires fewer third-party integrations.

#### --answer--

It lets users explore value before committing.

### --question--

#### --text--

What does a good responsive image setup accomplish on mobile devices?

#### --distractors--

It reduces color depth for performance.

---

It triggers a mobile-only animation.

---

It stretches images to fill available space.

#### --answer--

It adapts image size without losing quality.

### --question--

#### --text--

What is the purpose of establishing a strong visual hierarchy in UI design?

#### --distractors--

It ensures animations run smoothly on low-end devices.

---

It helps with color contrast and branding.

---

It reduces the need for progressive disclosure.

#### --answer--

It guides the user's eye through information in the intended order.

### --question--

#### --text--

Why is contrast more than just choosing black text on white?

#### --distractors--

It's about matching brand fonts.

---

It's mainly about marketing visibility.

---

Contrast ensures pixel-perfect accuracy.

#### --answer--

Contrast must work across all lighting conditions and devices.

### --question--

#### --text--

Why is user testing critical when refining an interface design?

#### --distractors--

It determines how well colors follow contrast ratio guidelines.

---

It helps finalize stakeholder preferences.

---

It reduces the time spent on writing design briefs.

#### --answer--

It reveals how users interact with the interface in practice.

### --question--

#### --text--

What is A/B testing based on standard UI design practices?

#### --distractors--

It requires smaller participant groups.

---

It uses exit interviews to gather feedback.

---

It only applies to mobile-first designs.

#### --answer--

It tests a new feature with a random subset of users.

### --question--

#### --text--

What does alignment help achieve in a visual layout?

#### --distractors--

It balances all colors equally across the design.

---

It increases contrast between unrelated elements.

---

It forces all elements into the same grid.

#### --answer--

It makes the design look organized and visually clean.

### --question--

#### --text--

Which of the following best describes the goal of composition in visual design?

#### --distractors--

Grouping all UI elements in one corner of the screen.

---

Scaling up every element to fit the full canvas.

---

Using only symmetrical layouts for visual consistency.

#### --answer--

Arranging elements so they relate to each other in a harmonious way.

### --question--

#### --text--

Which design principle is concerned with distributing visual weight to create a sense of equilibrium?

#### --distractors--

Scale

---

Hierarchy

---

Composition

#### --answer--

Balance

### --question--

#### --text--

What does hierarchy help users do when interacting with a visual design?

#### --distractors--

Zoom in on text for better readability.

---

Access navigation menus without scrolling.

---

Choose between symmetrical and asymmetrical layouts.

#### --answer--

Understand which elements are most important at a glance.

### --question--

#### --text--

Which of the following best defines white space in a design context?

#### --distractors--

The white background color used for body text.

---

A gap that must be filled with branding elements.

---

The padding used between interactive buttons.

#### --answer--

The empty area around or between visual elements.

### --question--

#### --text--

What is vector-based design?

#### --distractors--

Drawing with pixel-based tools for realistic detail.

---

Editing scanned images using raster techniques.

---

Building mockups with photos and bitmap textures.

#### --answer--

Creating art using formulas for lines, shapes, and colors.

