---
id: 66ed9009f45ce3ece4053eb7
title: CSS Relative and Absolute Units Quiz
challengeType: 8
dashedName: quiz-css-relative-and-absolute-units
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What is an absolute unit?

#### --distractors--

Units that adjust dynamically based on screen size.

---

Units that depend on the font size of the parent element.

---

Units measured in percentages of the viewport.

#### --answer--

Fixed length units that are not relative to anything else.

### --question--

#### --text--

What does `100vw` cover in terms of screen width?

#### --distractors--

`100%` of the screen width.

---

`100%` of the viewport height.

---

`100%` of the parent's width.

#### --answer--

`100%` of the viewport width.

### --question--

#### --text--

Which of the following is a relative unit?

#### --distractors--

`pt`

---

`cm`

---

`mm`

#### --answer--

`em`

### --question--

#### --text--

If the root font size is `20px`, what is `1rem` equal to?

#### --distractors--

`18px`

---

`16px`

---

`10px`

#### --answer--

`20px`

### --question--

#### --text--

What can the `calc()` function do in CSS?

#### --distractors--

Modify colors dynamically.

---

Set a fixed width.

---

Only work with percentages.

#### --answer--

Add, subtract, multiply, or divide different units.

### --question--

#### --text--

Which unit is the most commonly used absolute unit in CSS?

#### --distractors--

`inch`

---

`rem`

---

`%`

#### --answer--

`px`

### --question--

#### --text--

If the viewport height is `800px`, what would `50vh` be?

#### --distractors--

`50px`

---

`200px`

---

`100px`

#### --answer--

`400px`

### --question--

#### --text--

What does setting an element's width to `100%` mean?

#### --distractors--

It takes up the full width of the document.

---

It takes up the full width of the screen.

---

It takes up `100px`.

#### --answer--

It takes up the full width of its parent.

### --question--

#### --text--

What happens with `calc(10px + 20%)` in CSS?

#### --distractors--

It adds `10px` to `10%` of the document width.

---

It always equals `30px`.

---

It adds `10px` to `20%` of the screen width.

#### --answer--

It adds `10px` to `20%` of the parent's width.

### --question--

#### --text--

Which unit is relative to the font size of the root element?

#### --distractors--

`px`

---

`pt`

---

`%`

#### --answer--

`rem`

### --question--

#### --text--

With a root font size of `16px`, how big is `10rem`?

#### --distractors--

`140px`

---

`10px`

---

`100px`

#### --answer--

`160px`

### --question--

#### --text--

Why might you use `point` instead of `pixels` in design?

#### --distractors--

Points are scalable.

---

Points are better for responsive layouts.

---

Points are easier to manage on screens.

#### --answer--

Points are for print design.

### --question--

#### --text--

Why are `rem` units preferred over `pixels` in typography?

#### --distractors--

Because they provide fixed sizing regardless of screen resolution.

---

Because they ensure compatibility with older browsers.

---

Because they are easier to implement in responsive designs.

#### --answer--

Because they scale proportionally with the user’s browser settings.

### --question--

#### --text--

How much screen space does `80vw` take?

#### --distractors--

`80%` of the parent's width.

---

`100%` of the viewport height.

---

`80px`

#### --answer--

`80%` of the viewport width.

### --question--

#### --text--

Which units should you use if you want to make an element occupy a certain width or height by the percentage of the screen?

#### --distractors--

`pt` and `px`

---

`rem` and `em`

---

`pt` and `pc`

#### --answer--

`vw` and `vh`

### --question--

#### --text--

What does `vw` stand for?

#### --distractors--

Vertical Width.

---

Virtual Width.

---

Variable Width.

#### --answer--

Viewport Width.

### --question--

#### --text--

What's the key difference between `rem` and `em` in CSS?

#### --distractors--

`em` is relative to the root element, while `rem` is relative to the parent element.

---

`rem` is relative to desktop width, while `em` is relative to mobile width.

---

`rem` is relative to the user-defined width, while `em` is relative to the browser width.

#### --answer--

`em` is relative to the font size of the parent element, while `rem` is relative to the root element.

### --question--

#### --text--

What is a `vh` unit?

#### --distractors--

A unit based on the width of the viewport.

---

A unit based on the height of the element.

---

A unit that adjusts based on font size.

#### --answer--

A unit equal to 1% of the viewport height.

### --question--

#### --text--

What does setting an element's width to `auto` do in CSS?

#### --distractors--

It sets the width to `100%` of the parent element by default.

---

It sets the width to `50%` of the viewport unless other styles override it.

---

It sets the width to `0px` if no content or padding is present. 

#### --answer--

It allows the browser to determine the width based on the content and container.

### --question--

#### --text--

What’s a key advantage of the `calc()` function?

#### --distractors--

It automatically minifies your CSS files for better performance.

---

It enables the use of variables within CSS without any preprocessors.

---

It allows embedding JavaScript expressions directly within CSS rules.

#### --answer--

It lets you determine the value of a CSS property dynamically based on different aspects of the application or viewport.

