---
id: 66ed9002f45ce3ece4053eb6
title: CSS Pseudo-classes Quiz
challengeType: 8
dashedName: quiz-css-pseudo-classes
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

What are pseudo-classes?

#### --distractors--

They are CSS rules that create additional content within an element when needed.

---

They are properties that adjust an element's size or layout on the page.

---

They are selectors used to add movement effects to an element during interactions.

#### --answer--

They are keywords added to a selector that style an element based on its state.

### --question--

#### --text--

Which pseudo-class applies when a pointing device is being positioned over an element?

#### --distractors--

`:focus`

---

`:active`

---

`:checked`

#### --answer--

`:hover`

### --question--

#### --text--

Which pseudo-element allows you to style the first letter of a paragraph?

#### --distractors--

`:first-letter`

---

`:first-child`

---

`:last-of-type`

#### --answer--

`::first-letter`

### --question--

#### --text--

Which pseudo-class changes the style of an element while it is being clicked?

#### --distractors--

`:focus`

---

`:hover`

---

`:checked`

#### --answer--

`:active`

### --question--

#### --text--

Which pseudo-class is used to style an element when it is ready to receive user input, such as a text field being clicked or tabbed into?

#### --distractors--

`::focus`

---

`:active`

---

`:visited`

#### --answer--

`:focus`

### --question--

#### --text--

Which of the following CSS rules correctly adds the text `Note:` in front of each paragraph element with a class of `note`?

#### --distractors--

```css
.note::before {
  content: "Note:";
}
```

---

```css
p.note::after {
  content: "Note:";
}
```

---

```css
p::before {
  content: "Note:";
}
```

#### --answer--

```css
p.note::before {
  content: "Note:";
}
```

### --question--

#### --text--

Which pseudo-class applies to an input field when it is selected or toggled on?

#### --distractors--

`:required`

---

`:disabled`

---

`:optional`

#### --answer--

`:checked`

### --question--

#### --text--

Which of the following is the correct syntax to style the last child of a list?

#### --distractors--

```css
li:nth-child(last) {
  color: blue;
}
```

---

```css
#li:last-child {
  color: blue;
}
```

---

```css
.li:last-child() {
  color: blue;
}
```

#### --answer--

```css
li:last-child {
  color: blue;
}
```

### --question--

#### --text--

Which pseudo-class targets input fields that are not required to fill out?

#### --distractors--

`:required`

---

`:enabled`

---

`::optional`

#### --answer--

`:optional`

### --question--

#### --text--

What does the `:disabled` pseudo-class do?

#### --distractors--

It styles checked inputs.

---

It styles elements being hovered over.

---

It selects elements that do not match a given selector.

#### --answer--

It styles elements that are not available for user interaction.

### --question--

#### --text--

Which pseudo-class applies when a form input meets its validation criteria?

#### --distractors--

`:checked`

---

`:required`

---

`:disabled`

#### --answer--

`:valid`

### --question--

#### --text--

Which one of these is not a location pseudo-class?

#### --distractors--

`:visited`

---

`:any-link`

---

`:link`

#### --answer--

`:current`

### --question--

#### --text--

Which of the following selects the third list item?

#### --distractors--

```css
li:child(3) {
  color: red;
}
```

---

```css
li:last-child(3) {
  color: red;
}
```

---

```css
li:nth-child(three) {
  color: red;
}
```

#### --answer--

```css
li:nth-child(3) {
  color: red;
}
```

### --question--

#### --text--

Which elements will have a `color` of `blue` with the following CSS?

```css
p:is(.blue, .highlight) {
  color: blue;
}
```

#### --distractors--

```html
<p class="class">Paragraph 1</p>
<p class="highlight">Paragraph 2</p>
```

---

```html
<div class="blue">Paragraph 1</div>
<div class="highlight">Paragraph 2</div>
```

---

```html
<p>Paragraph 1</p>
<span class="highlight">Paragraph 2</span>
```

#### --answer--

```html
<p class="blue">Paragraph 1</p>
<p class="highlight">Paragraph 2</p>
```

### --question--

#### --text--

What does the `:not()` pseudo-class do?

#### --distractors--

It adds styles to all elements.

---

It selects all child elements of a parent.

---

It selects elements that match a given selector.

#### --answer--

It selects elements that do not match a given selector.

### --question--

#### --text--

What does the following CSS rule do?

```css
p:first-of-type {
  font-style: italic;
}
```

#### --distractors--

It selects the first `p` element in the document.

---

It selects all `p` elements in the document.

---

It selects the first child of every `p` element.

#### --answer--

It selects the first `p` element within a parent container.

### --question--

#### --text--

What does the `:last-of-type` pseudo class do?

#### --distractors--

It selects the first child element of a specific type within its parent.

---

It selects the middle child element of a specific type within its parent.

---

It selects every child element of a specific type within its parent.

#### --answer--

It selects the last child element of a specific type within its parent.

### --question--

#### --text--

Which pseudo-class is used to select the second item in a list?

#### --distractors--

`:first-child`

---

`:required`

---

`:is()`

#### --answer--

`:nth-child(2)`

### --question--

#### --text--

Which one of these is a functional pseudo-class?

#### --distractors--

`:first-child`

---

`:match()`

---

`:checked`

#### --answer--

`:is()`

### --question--

#### --text--

Which one of these is not a functional pseudo-class?

#### --distractors--

`:has()`

---

`:not()`

---

`:where()`

#### --answer--

`:contains()`

## --quiz--

### --question--

#### --text--

Which pseudo-class is used to target form elements that are enabled?

#### --distractors--

`:disabled`

---

`:active`

---

`:focus`

#### --answer--

`:enabled`

### --question--

#### --text--

Which pseudo-class allows you to select elements by counting from the end?

#### --distractors--

`:nth-child(n)`

---

`:last-child`

---

`:last-of-type`

#### --answer--

`:nth-last-child(n)`

### --question--

#### --text--

Which of the following allows you to select elements that contain specific child elements?

#### --distractors--

`:is()`

---

`:where()`

---

`:in-range`

#### --answer--

`:has()`

### --question--

#### --text--

Which of the following selects elements that do not contain any content or child elements?

#### --distractors--

`:only-child`

---

`:last-child`

---

`:not()`

#### --answer--

`:empty`

### --question--

#### --text--

What does this CSS selector target?

```css
input:invalid {
  background-color: red;
}
```

#### --distractors--

All input elements.

---

All input elements with values inside the allowed range.

---

All input elements that pass validation.

#### --answer--

All input elements that fail validation.

### --question--

#### --text--

Which pseudo-class selects input fields whose value is automatically filled by the browser?

#### --distractors--

`:visited`

---

`:valid`

---

`:where()`

#### --answer--

`:autofill`

### --question--

#### --text--

Which pseudo-class selects an element if it or any of its descendants is focused?

#### --distractors--

`:focus`

---

`:in-range`

---

`:only-child`

#### --answer--

`:focus-within`

### --question--

#### --text--

Which pseudo class represents links that point to the same document?

#### --distractors--

`:target`

---

`:visited`

---

`:link`

#### --answer--

`:local-link`

### --question--

#### --text--

Which of the following styles the `p` element when it is the target of a URL fragment?

#### --distractors--

```css
p:empty {
  background-color: gold;
}
```

---

```css
p:not(.targeted) {
  background-color: gold;
}
```

---

```css
p:is(.target) {
  background-color: gold;
}
```

#### --answer--

```css
p:target {
  background-color: gold;
}
```

### --question--

#### --text--

Which pseudo-class is used when an element is the target of a URL fragment?

#### --distractors--

`:focus-within`

---

`:hover`

---

`:visited`

#### --answer--

`:target`

### --question--

#### --text--

What does the `:only-child` pseudo-class select?

#### --distractors--

It selects the parent element which has only one child.

---

It selects all child elements inside the parent element.

---

It selects the parent element that contains only one type of child element.

#### --answer--

It selects an element that has no siblings inside its parent element.

### --question--

#### --text--

Which pseudo-class selects an element if it's the only one of its type within its parent?

#### --distractors--

`:only-child`

---

`:nth-of-type(n)`

---

`:first-of-type`

#### --answer--

`:only-of-type`

### --question--

#### --text--

Which CSS rule will apply a `color` of `yellow` to the second `p` element in the following HTML?

```html
<div>
  <h1>Courses</h1>
  <p>HTML</p>
  <p>CSS</p>
  <p>JavaScript</p>
</div>
```

#### --distractors--

```css
p:nth-child(2) {
  color: yellow;
}
```

---

```css
p:first-of-type {
  color: yellow;
}
```

---

```css
p:last-of-type {
  color: yellow;
}
```

#### --answer--

```css
p:nth-of-type(2) {
  color: yellow;
}
```

### --question--

#### --text--

Which pseudo-element allows you to select the marker of list items for styling?

#### --distractors--

`::before`

---

`::after`

---

`:root`

#### --answer--

`::marker`

### --question--

#### --text--

Which pseudo-class allows you to target the highest-level element in the document, typically the `html` element?

#### --distractors--

`:first-child`

---

`:in-range`

---

`:target`

#### --answer--

`:root`

### --question--

#### --text--

Which CSS pseudo-class has a specificity of zero, ensuring it won’t interfere with other specific styling rules?

#### --distractors--

`:is()`

---

`:not()`

---

`:focus`

#### --answer--

`:where()`

### --question--

#### --text--

Which one of the following is a tree-structural pseudo-class?

#### --distractors--

`:where()`

---

`:valid`

---

`:link`

#### --answer--

`:root`

### --question--

#### --text--

Which CSS rule will set the `background-color` of the following element to `red` if its value is outside the specified range?

```html
<input type="number" min="10" max="25"/>
```

#### --distractors--

```css
input:in-range {
  background-color: red;
}
```

---

```css
input {
  background-color: red;
}
```

---

```css
input:valid {
  background-color: red;
}
```

#### --answer--

```css
input:out-of-range {
  background-color: red;
}
```

### --question--

#### --text--

Which pseudo-element uses the `content` property to insert content after the element?

#### --distractors--

`::before`

---

`::marker`

---

`::first-letter`

#### --answer--

`::after`

### --question--

#### --text--

Which pseudo-class applies styles to an element if its value is within the specified range?

#### --distractors--

`:out-of-range`

---

`:enabled`

---

`:checked`

#### --answer--

`:in-range`
