---
id: 66ed8fd7f45ce3ece4053eb0
title: Lists, Links, Backgrounds and Borders Quiz
challengeType: 8
dashedName: quiz-css-backgrounds-and-borders
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

Which CSS property is used to specify the image to be used as a list item marker?

#### --distractors--

`list-style-position`

---

`background-image`

---

`content-image`

#### --answer--

`list-style-image`

### --question--

#### --text--

Which property is used to control the position of the list item marker?

#### --distractors--

`list-style-type`

---

`list-position`

---

`position-marker`

#### --answer--

`list-style-position`

### --question--

#### --text--

What does the `line-height` property do?

#### --distractors--

It is used to set the background size for an element.

---

It is used to style links that have not be visited by the user.

---

It is used to create space to the right of list items.

#### --answer--

It is used to create space between lines of text.

### --question--

#### --text--

Which pseudo-class is used to style links when a user hovers over them?

#### --distractors--

`:hovered`

---

`:hovering`

---

`:hasHovered`

#### --answer--

`:hover`

### --question--

#### --text--

What is the default value for the `background-repeat` property?

#### --distractors--

`no-repeat`

---

`repeat-x`

---

`space`

#### --answer--

`repeat`

### --question--

#### --text--

Which CSS property can be used to control the size of a background image?

#### --distractors--

`image-size`

---

`background-fit`

---

`size-image`

#### --answer--

`background-size`

### --question--

#### --text--

Which of the following is the correct way to apply a solid red top border to an element?

#### --distractors--

`set-top-border: 3px solid red;`

---

`border-top: apply 3px solid red;`

---

`top-border: 3px solid red;`

#### --answer--

`border-top: 3px solid red;`

### --question--

#### --text--

Which of the following is NOT a valid `border` property?

#### --distractors--

`border-bottom`

---

`border-right`

---

`border-top`

#### --answer--

`border-side`

### --question--

#### --text--

Which of the following is a valid `border-style` value?

#### --distractors--

`wave`

---

`triple`

---

`zig zag`

#### --answer--

`dotted`

### --question--

#### --text--

Which of the following is the correct way to apply borders using the shorthand property?

#### --distractors--

```css
.box {
  borders: 1px solid black;
}
```

---

```css
.box {
  borderShort: 1px solid black;
}
```

---

```css
.box {
  border-short: 1px solid black;
}
```

#### --answer--

```css
.box {
  border: 1px solid black;
}
```

### --question--

#### --text--

What is the role of the `linear-gradient` function?

#### --distractors--

It is used to set the style of an element's border.

---

It is used to determine how background images should be repeated along the horizontal and vertical axes.

---

It is used to style an element that was activated by the user.

#### --answer--

It is used to create a transition between multiple colors along a straight line.

### --question--

#### --text--

Which value for the `background-repeat` property ensures the image repeats horizontally but not vertically?

#### --distractors--

`repeat-y`

---

`space`

---

`no-repeat`

#### --answer--

`repeat-x`

### --question--

#### --text--

What is the purpose of the `border-radius` property?

#### --distractors--

To create shadows around the border.

---

To change the width of the border.

---

To make the border disappear.

#### --answer--

To round the corners of an element.

### --question--

#### --text--

Which of the following is NOT a valid value for the `background-position` property?

#### --distractors--

`top`

---

`center`

---

`bottom`

#### --answer--

`side`

### --question--

#### --text--

Which of the following `background-repeat` values can be used to repeat a background image vertically?

#### --distractors--

`repeat-x`

---

`vertical-only`

---

`stretch`

#### --answer--

`repeat-y`

### --question--

#### --text--

What does `background-position: center;` do to a background image?

#### --distractors--

It aligns the background image to the top of the element.

---

It repeats the background image horizontally and vertically.

---

It scales the background image to fill the entire element.

#### --answer--

It positions the background image in the center of the element.

### --question--

#### --text--

Which of these is NOT a valid `border` value?

#### --distractors--

`1px solid black`

---

`3px dotted blue`

---

`2px dashed red`

#### --answer--

`5px inverted green`

### --question--

#### --text--

What does the `radial-gradient` function do?

#### --distractors--

It creates a background that transitions between multiple colors along a straight line.

---

It specifies whether the background image should scroll with the content or remain fixed in place.

---

It is used to style an element that was activated by the user.

#### --answer--

It creates an image that radiates from a particular point and gradually transitions between multiple colors.

### --question--

#### --text--

Which of the following is NOT a valid pseudo-class?

#### --distractors--

`:focus`

---

`:visited`

---

`:link`

#### --answer--

`:before`

### --question--

#### --text--

Which of the following shows the `background` shorthand property being used properly?

#### --distractors--

```css
body {
  background: apply url("example-url-goes-here");
}
```

---

```css
body {
  background: set url("example-url-goes-here");
}
```

---

```css
body {
  background: 2px solid red url("example-url-goes-here");
}
```

#### --answer--

```css
body {
  background: no-repeat url("example-url-goes-here");
}
```

## --quiz--

### --question--

#### --text--

What kind of values can the `line-height` property accept?

#### --distractors--

Only pixel values

---

Only keyword values like `inherit`

---

Only em units

#### --answer--

Numbers, percentages, and length units

### --question--

#### --text--

Which of the following is not a valid value for `line-height`?

#### --distractors--

`normal`

---

`150%`

---

`2em`

#### --answer--

`bold`

### --question--

#### --text--

What does `list-style-type` control?

#### --distractors--

The position of a list marker

---

The spacing of list items

---

The alignment of list items

#### --answer--

The marker symbol used in a list

### --question--

#### --text--

Which value is not valid for `list-style-type`?

#### --distractors--

`circle`

---

`disc`

---

`square`

#### --answer--

`hexagon`

### --question--

#### --text--

What are the two acceptable values for `list-style-position`?

#### --distractors--

`top` and `bottom`

---

`inline` and `block`

---

`left` and `right`

#### --answer--

`inside` and `outside`

### --question--

#### --text--

Which CSS property adds spacing outside each list item to improve readability?

#### --distractors--

`padding`

---

`line-height`

---

`text-indent`

#### --answer--

`margin`

### --question--

#### --text--

What does the `:link` pseudo-class target?

#### --distractors--

All hyperlinks

---

Hovered links

---

Already visited links

#### --answer--

Unvisited links

### --question--

#### --text--

What pseudo-class styles a link when the user has already clicked on it?

#### --distractors--

`:hover`

---

`:link`

---

`:focus`

#### --answer--

`:visited`

### --question--

#### --text--

Which pseudo-class styles an element when it gains input focus?

#### --distractors--

`:hover`

---

`:visited`

---

`:target`

#### --answer--

`:focus`

### --question--

#### --text--

When does the `:active` pseudo-class apply?

#### --distractors--

When the link is first loaded

---

When the user is not interacting

---

When the browser finishes rendering

#### --answer--

When a user clicks or taps the element

### --question--

#### --text--

Which pseudo-class is used for hover effects?

#### --distractors--

`:link`

---

`:click`

---

`:active`

#### --answer--

`:hover` 

### --question--

#### --text--

What does `background-size: cover` do?

#### --distractors--

Repeats the image in all directions

---

Crops the image

---

Fixes the image in one position

#### --answer--

Scales the image to fill the element while preserving aspect ratio

### --question--

#### --text--

Which value of `background-repeat` will repeat the background image both horizontally and vertically?

#### --distractors--

`no-repeat`

---

`repeat-x`

---

`space`

#### --answer--

`repeat`

### --question--

#### --text--

Which property sets where the background image is placed?

#### --distractors--

`background-location`

---

`background-origin`

---

`background-place`

#### --answer--

`background-position`

### --question--

#### --text--

What value of `background-attachment` keeps the image fixed when scrolling?

#### --distractors--

`scroll`

---

`static`

---

`sticky`

#### --answer--

`fixed`

### --question--

#### --text--

Which of the following correctly sets a background image that doesn’t repeat and is centered?

#### --distractors--

`background: no-repeat-center img("img.png");`

---

`background: image url("img.png") center;`

---

`background-position: center no-repeat url("img.png");`

#### --answer--

`background: center no-repeat url("img.png");`

### --question--

#### --text--

Which property is used to set the top, right, bottom, and left borders in a single declaration?

#### --distractors--

`border-style`

---

`border-radius`

---

`outline`

#### --answer--

`border`

### --question--

#### --text--

What effect does setting `border-radius: 10px;` have on an element?

#### --distractors--

It changes the border's opacity

---

It creates a 10-pixel border

---

It adds a 10px shadow

#### --answer--

It rounds the corners of the element

### --question--

#### --text--

Which of the following CSS rules correctly creates a linear gradient from red to yellow?

#### --distractors--

`background: gradient-linear(red to yellow);`

---

`background: linear(red, yellow);`

---

`background-color: gradient(red, yellow);`

#### --answer--

`background: linear-gradient(red, yellow);`

### --question--

#### --text--

Which of the following CSS declarations correctly applies a radial gradient from white in the center to blue at the edges?

#### --distractors--

`background: linear-gradient(white to blue);`

---

`background: gradient-radial(white to blue);`

---

`background: radial-gradient(blue, white);`

#### --answer--

`background: radial-gradient(white, blue);`

