---
id: 66df3b712c41c499e9d31e5b
title: Basic HTML Quiz
challengeType: 8
dashedName: quiz-basic-html
---

# --description--

To pass the quiz, you must correctly answer at least 18 of the 20 questions below.

# --quizzes--

## --quiz--

### --question--

#### --text--

How does the `loop` attribute work inside the `audio` element?

#### --distractors--

It allows the `audio` element to synchronize playback with other multimedia elements on the webpage.

---

It adjusts the pitch and tone of the audio.

---

It triggers the `audio` element to stop and restart playback in a random sequence.

#### --answer--

It starts the audio again once it is finished.

### --question--

#### --text--

What is a void element in HTML?

#### --distractors--

An element used to embed videos on the screen.

---

An element for displaying lists.

---

An element used for embedding sound in to the document.

#### --answer--

An element without any content or an end tag.

### --question--

#### --text--

Which of the following is a correct value for the `id` attribute?

#### --distractors--

`id="main@content"`

---

`id="main content"`

---

`id="main~content"`

#### --answer--

`id="main-content"`

### --question--

#### --text--

How does `target="_parent"` work?

#### --distractors--

It opens a link in a new browsing context.

---

It specifies the position within the linked document where the browser should scroll to after clicking the link.

---

It redirects the user to a different website specified in the `href` attribute.

#### --answer--

It opens a link in the parent of the current context.

### --question--

#### --text--

What is the difference between a boolean and regular attribute?

#### --distractors--

Boolean attributes can only be used with checkboxes, while regular attribute are used with radio buttons.

---

Regular attributes are always required for images, while boolean attributes are optional.

---

Boolean attributes must always have a value assigned to them, while regular attributes do not need values assigned to them.

#### --answer--

A boolean attribute can be present or absent, while a regular attribute always has a specified value.

### --question--

#### --text--

Which element is used to link scripts to your HTML file?

#### --distractors--

`img`

---

`ul`

---

`h2`

#### --answer--

`script`

### --question--

#### --text--

What is an HTML boilerplate?

#### --distractors--

A special tool used by web developers to add watermarks to documents.

---

A type of markup language.

---

A plugin that automatically generates "lorem ipsum" text on the page.

#### --answer--

A template that includes all of the essential information needed for an HTML document.

### --question--

#### --text--

Which attribute applies a unique identifier to an HTML element?

#### --distractors--

`class`

---

`href`

---

`action`

#### --answer--

`id`

### --question--

#### --text--

What is an HTML entity (character reference)?

#### --distractors--

A graphical representation of a character in HTML.

---

A special formatting tag used in HTML.

---

An image used to represent a character in web design.

#### --answer--

A set of characters used to represent a reserved character in HTML.

### --question--

#### --text--

What is the purpose of the `audio` element?

#### --distractors--

It is used to allow users to record their voice directly on a webpage.

---

It is used to style `audio` and `video` elements on the page.

---

It is used to make text on a webpage audible when clicked.

#### --answer--

It is used to add audio to the HTML document.

### --question--

#### --text--

Which of the following is NOT an example of an HTML element?

#### --distractors--

`img`

---

`h1`

---

`link`

#### --answer--

`byte`

### --question--

#### --text--

What is the role of the `target` attribute inside anchor elements?

#### --distractors--

It defines the color of the link when it is hovered over by the user.

---

It specifies the position within the linked document where the browser should scroll to after clicking the link.

---

It determines the font size of the anchor text inside the `link` element.

#### --answer--

It is used to specify where the linked document will be opened when the user clicks on the link.

### --question--

#### --text--

What is an absolute path?

#### --distractors--

A path that is relative to the current file.

---

A path that includes variables.

---

A path that includes wildcard characters.

#### --answer--

A complete path to a resource, starting from the root directory.

### --question--

#### --text--

What is the role of the `link` element in HTML?

#### --distractors--

It's used to create hyperlinks within the same webpage.

---

It's used to define the layout and structure of a webpage.

---

It's used to embed audio or video files into a webpage.

#### --answer--

It's used to link to external resources like stylesheets and site icons.

### --question--

#### --text--

Which of the following is a valid value for working with open graph properties?

#### --distractors--

`"og:socialMedia"`

---

`"og:mediaOG"`

---

`"og:openGraph"`

#### --answer--

`"og:title"`

### --question--

#### --text--

Which of the following is an example of a boolean attribute?

#### --distractors--

`href`

---

`src`

---

`width`

#### --answer--

`checked`

### --question--

#### --text--

Which of the following is a correct syntax for the `img` element?

#### --distractors--

`<img src="image.jpg" alt="Description of the image"></img>`

---

`<img source="image.jpg" desc="Description of the image"></img>`

---

`<img src="image.jpg" desc="Description of the image">`

#### --answer--

`<img src="image.jpg" alt="Description of the image">`

### --question--

#### --text--

What is the `iframe` element used for?

#### --distractors--

It's used to add captions to images.

---

It's used to add copyright information for media.

---

It's used to create hyperlinks within the same webpage.

#### --answer--

It's used to embed another document within the current HTML document.

### --question--

#### --text--

Which of the following is NOT a valid link state for anchor elements?

#### --distractors--

`hover`

---

`visited`

---

`active`

#### --answer--

`href`

### --question--

#### --text--

What is the role of the `title` element?

#### --distractors--

An element that allows users to edit the source code of a webpage.

---

It defines the layout and positioning of elements within a web page.

---

It's used to embed videos and multimedia content directly into an HTML document.

#### --answer--

It specifies the title for a document and appears in the browser tab or window.

## --quiz--

### --question--

#### --text--

Which of the following `target` attributes opens a link in the parent of the current context?

#### --distractors--

`_blank`

---

`_self`

---

`_unfencedTop`

#### --answer--

`_parent`

### --question--

#### --text--

Which attribute is used to set the `UTF-8` character encoding for an HTML document?

#### --distractors--

`accept`

---

`capture`

---

`enctype`

#### --answer--

`charset`

### --question--

#### --text--

What is the role of HTML on the web?

#### --distractors--

HTML is used for style and layout.

---

HTML is used to add interactivity on the page.

---

HTML is a registry for software packages.

#### --answer--

HTML represents the content and structure for a web page.

### --question--

#### --text--

Which image license works for the public domain?

#### --distractors--

JPG

---

Creative Commons.

---

BSD

#### --answer--

Creative Commons 0.

### --question--

#### --text--

How do you set a boolean attribute to `false`?

#### --distractors--

By setting the attribute value to `0`.

---

By using the `not` operator before the attribute name.

---

By setting the attribute to an empty string (`""`).

#### --answer--

By omitting the attribute from the element.

### --question--

#### --text--

What is the `script` element used for?

#### --distractors--

It's used to embed CSS into the HTML document or link to an external CSS file.

---

It's used to embed Pascal code into the HTML document.

---

It's used to embed C# code into the HTML document.

#### --answer--

It's used to embed JavaScript into the HTML document or link to an external JavaScript file.

### --question--

#### --text--

Which of the following elements is used to set the title for an HTML document?

#### --distractors--

`footer`

---

`section`

---

`figcaption`

#### --answer--

`title`

### --question--

#### --text--

What is the `class` attribute typically used for?

#### --distractors--

It's used to embed metadata about the element.

---

It's used to define inline styles directly within the HTML tag.

---

It's used to specify unique identifiers for JavaScript functions.

#### --answer--

It's used to apply a set of styles to multiple elements.

### --question--

#### --text--

Which of the following is NOT an example of a commonly used HTML entity?

#### --distractors--

`&quot;` (Double quote).

---

`&copy;` (Copyright symbol).

---

`&gt;` (Greater than Symbol).

#### --answer--

`&div;` (div element).

### --question--

#### --text--

Which element is used to add audio to your HTML document?

#### --distractors--

`media`

---

`video`

---

`hr`

#### --answer--

`audio`

### --question--

#### --text--

Where is the content represented on the page placed in an HTML document?

#### --distractors--

In between the `head` and the `body` elements.

---

Within the `repr` element.

---

Within the `script` element.

#### --answer--

Within the `body` element.

### --question--

#### --text--

Which attribute is used to start the audio again once it is finished?

#### --distractors--

`multiple`

---

`inputmode`

---

`enctype`

#### --answer--

`loop`

### --question--

#### --text--

Which of the following is the correct syntax for a `div` element?

#### --distractors--

`<<div>>block container<</div>>`

---

`>>div>>block container>>div>>`

---

`[div]block container[/div]`

#### --answer--

`<div>block container</div>`

### --question--

#### --text--

How does `target="_self"` work?

#### --distractors--

It specifies the position within the linked document where the browser should scroll to after clicking the link.

---

It automatically downloads the linked document to the user's computer.

---

It redirects the user to a different website specified in the `href` attribute.

#### --answer--

It opens a link in the current browsing context.

### --question--

#### --text--

What is a relative path?

#### --distractors--

It specifies the exact location of a file or directory from the root directory of the file system.

---

It includes the full URL starting from the domain name to the specific file or directory.

---

It always begins with a forward slash (`/`) indicating the root directory of the website or file system.

#### --answer--

It specifies the location of a file or directory relative to the current working directory.

### --question--

#### --text--

Which of the following elements is the correct syntax for a `link` element?

#### --distractors--

`<link rel="stylesheet" href="./styles.css"></link>`

---

`</link rel="stylesheet" href="./styles.css"></link>`

---

`<<link rel="stylesheet" href="./styles.css"></link>>`

#### --answer--

`<link rel="stylesheet" href="./styles.css" />`

### --question--

#### --text--

Which of the following is NOT a valid value for working with open graph properties?

#### --distractors--

`"og:title"`

---

`"og:type"`

---

`"og:image"`

#### --answer--

`"og:socialMedia"`

### --question--

#### --text--

Which of the following is the correct syntax for a paragraph element?

#### --distractors--

`>p>paragraph element>/p>`

---

`<<p>>paragraph element<</p>>`

---

`<p>`

#### --answer--

`<p>paragraph element</p>`

### --question--

#### --text--

What does the name of the `iframe` element stand for?

#### --distractors--

Inline Framing

---

Inner Frame

---

Inline video

#### --answer--

Inline Frame

### --question--

#### --text--

What does the active state mean for anchor elements?

#### --distractors--

The link is disabled and cannot be clicked.

---

The mouse cursor is over the link.

---

The link has been visited by the user.

#### --answer--

A user is actively clicking on it.

## --quiz--

### --question--

#### --text--

Which of the following will open the link in a new browser tab?

#### --distractors--

```html
<a target="_parent" href="https://freecatphotoapp.com">cat photos</a>
```

---

```html
<a target="_top" href="https://freecatphotoapp.com">cat photos</a>
```

---

```html
<a target="_self" href="https://freecatphotoapp.com">cat photos</a>
```

#### --answer--

```html
<a target="_blank" href="https://freecatphotoapp.com">cat photos</a>
```

### --question--

#### --text--

Which of the following is a void element?

#### --distractors--

`div`

---

`section`

---

`p`

#### --answer--

`img`

### --question--

#### --text--

Which of the following is the correct way to use HTML entities?

#### --distractors--

`<p>This is an &lt&img /&gt& element</p>`

---

`<p>This is an ;lt&img /;gt& element</p>`

---

`<p>This is an ;lt;img /;gt; element</p>`

#### --answer--

`<p>This is an &lt;img /&gt; element</p>`

### --question--

#### --text--

What is the `ul` element used for in HTML?

#### --distractors--

It is used to group a list of images only.

---

It is used to group a list of links only.

---

It is used to group an ordered list of items.

#### --answer--

It is used to group a bulleted list of items.

### --question--

#### --text--

Which of the following is the correct way to apply multiple classes to an HTML element?

#### --distractors--

```html
<div class="box>>red>>box"></div>
``` 

---

```html
<div class="box<<red<<box"></div>
``` 

---

```html
<div class="box-red-box"></div>
``` 

#### --answer--

```html
<div class="box red-box"></div>
``` 

### --question--

#### --text--

Which of the following elements is used to represent an ordered list of items?

#### --distractors--

`span`

---

`div`

---

`ul`

#### --answer--

`ol` 

### --question--

#### --text--

What are open graph properties used for?

#### --distractors--

These properties are used to embed interactive multimedia content directly into web pages.

---

These properties are used to generate dynamic pop-up advertisements on websites.

---

These properties are used to encrypt sensitive data transmitted between web servers and users' browsers.

#### --answer--

These properties are used to set how a website's content will be seen on different social media platforms. 

### --question--

#### --text--

Which of the following is used to set a short description for a web page?

#### --distractors--

```html
<meta
  add="description"
  content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
``` 

---

```html
<meta
  set="description"
  content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
``` 

---

```html
<meta
  description="description"
  content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
``` 

#### --answer--

```html
<meta
  name="description"
  content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
``` 

### --question--

#### --text--

What does SVG stand for?

#### --distractors--

Scalable Vector Graph

---

Scalable Vistor Graphics

---

Site Vector Graphics

#### --answer--

Scalable Vector Graphics 

### --question--

#### --text--

What is the role of the `footer` element?

#### --distractors--

This element is used to group related captions and images on a web page. 

---

This element is used to create horizontal lines in between paragraphs on the page.

---

This element is used to create a list of ordered items at the bottom of the page. 

#### --answer--

This element is used to group copyright content or related documents at the bottom of the page. 

### --question--

#### --text--

What is `UTF-8` character encoding?

#### --distractors--

It is a standardized character encoding used to set the title for a web page.

---

It is a set of characters used to set the page description for the web page.

---

It is a special set of characters used in elements to improve media performance. 

#### --answer--

It is a standardized character encoding widely used on the web.  

### --question--

#### --text--

Which of the following is an example of a replaced element?

#### --distractors--

`slot`

---

`div`

---

`p`

#### --answer--

`iframe` 

### --question--

#### --text--

Which of the following is considered the most important heading on a web page?

#### --distractors--

`h6`

---

`h3`

---

`h5`

#### --answer--

`h1` 

### --question--

#### --text--

Which of the following elements is used to link to external resources like stylesheets and site icons?

#### --distractors--

`a`

---

`p`

---

`div`

#### --answer--

`link` 

### --question--

#### --text--

Which of the following elements is used to convey a sense of urgency, seriousness or strong importance?

#### --distractors--

`important`

---

`heavy`

---

`strength`

#### --answer--

`strong`

### --question--

#### --text--

What is the role of the `figcaption` element?

#### --distractors--

It provides captions for the content inside a `span` element. 

---

It provides captions for the content inside a `slot` element. 

---

It provides captions for the content inside a `div` element. 

#### --answer--

It provides captions for the content inside a `figure` element. 

### --question--

#### --text--

Which of the following is the correct way to set the `DOCTYPE` declaration for an HTML document?

#### --distractors--

`<DOCTYPE>`

---

`<*DOCTYPE html>`

---

`<<DOCTYPE html>>`

#### --answer--

`<!DOCTYPE html>`

### --question--

#### --text--

What is the purpose of the `head` element in an HTML document?

#### --distractors--

It is a container of anchor elements for the HTML document. 

---

It is a container of images for the HTML document. 

---

It is a container of heading elements for the HTML document. 

#### --answer--

It is a container of meta data for the HTML document. 

### --question--

#### --text--

Which of the following is the correct way to set the language of the HTML document to english?

#### --distractors--

`<html lang-set="en">` 

---

`<html set-lang="en">` 

---

`<html language="en">` 

#### --answer--

`<html lang="en">` 

### --question--

#### --text--

Which of the following elements should NOT be placed inside of the `head`?

#### --distractors--

`link`

---

`meta`

---

`title`

#### --answer--

`img` 

## --quiz--

### --question--

#### --text--

Which of the following is NOT a correct statement about absolute and relative paths?

#### --distractors--

Absolute paths start from the root directory, while relative paths depend on the location of the current file.

---

Relative paths are shorter and more flexible for linking within a website, while absolute paths include the full URL.

---

Both absolute and relative paths can be used to link to files within the same website.

#### --answer--

Relative paths cannot use `..` to move up directories, but absolute paths can.

### --question--

#### --text--

Which of the following is NOT a valid target attribute value in an `a` tag?

#### --distractors--

`_self`

---

`_parent`

---

`_top`

#### --answer--

`_main`

### --question--

#### --text--

What is the purpose of the `controls` attribute in the `audio` element?

#### --distractors--

It defines the audio file format for the browser to use.

---

It automatically starts the audio when the page loads.

---

It specifies the audio file’s source URL.

#### --answer--

It adds built-in playback controls like play, pause, and volume adjustment.

### --question--

#### --text--

Which of the following elements improves SEO by providing a brief description of the web page?

#### --distractors--

```html
<meta
 description="describe"
 content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
```

---

```html
<meta
 name="desc"
 content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
```

---

```html
<meta
 description="description"
 content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
```

#### --answer--

```html
<meta
 name="description"
 content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
```

### --question--

#### --text--

What does `<meta charset="utf-8" />` do?

#### --distractors--

Sets the language of the webpage to English.

---

Links an external CSS stylesheet.

---

Specifies the title of the webpage.

#### --answer--

Defines the character encoding to ensure proper text display.

### --question--

#### --text--

What is the difference between `link` and `script` elements in HTML?

#### --distractors--

`link` is for JavaScript files, and `script` is for CSS files.

---

Both `link` and `script` are used to style web pages.

---

`script` is for adding styles, and `link` is for running JavaScript.

#### --answer--

`link` is used to add styles from an external CSS file, while `script` is used to run JavaScript code.

### --question--

#### --text--

Which of the following statements about HTML classes and IDs is incorrect?

#### --distractors--

A class name can be used multiple times throughout an HTML document.

---

The `rel` attribute defines the relationship between the linked resource and the HTML document.

---

The `og:image` property is used to specify the image displayed in social media posts.

#### --answer--

ID names cannot contain underscores and must be unique.

### --question--

#### --text--

Which of the following statements about HTML heading elements is true?

#### --distractors--

The text size increases from `h1` to `h6`.

---

The text size remains the same for all heading elements.

---

`h3` is larger than `h2`.

#### --answer--

The text size decreases from `h1` to `h6`.

### --question--

#### --text--

Which statement is incorrect about HTML elements?

#### --distractors--

HTML elements are the basic building blocks of a webpage.

---

Some codebases include a forward slash (/) inside void elements.

---

A boolean attribute is one that works simply by being present or absent in a tag.

#### --answer--

Void elements contain content and only have a start tag.

### --question--

#### --text--

Which of the following statements about void elements in HTML is true?

#### --distractors--

A void element must always include a forward slash / before closing.

---

A void element should never include a forward slash /.

---

The forward slash / is mandatory for self-closing void elements in all versions of HTML.

#### --answer--

Both `<img>` and `<img/>` are acceptable in modern HTML.

### --question--

#### --text--

What is the primary purpose of comments in programming?

#### --distractors--

To make the code run faster.

---

To change how the browser displays content.

---

To store temporary data within the code.

#### --answer--

To leave notes for yourself and other developers in the code.

### --question--

#### --text--

Which target attribute opens a link in the same browsing context as the current one?

#### --distractors--

`_blank`

---

`_top`

---

`_parent`

#### --answer--

`_self`

### --question--

#### --text--

What is the purpose of the `em` element in HTML?

#### --distractors--

To make text bigger.

---

To change the text color.

---

To underline words for emphasis.

#### --answer--

To highlight important text by making it italic.

### --question--

#### --text--

What does the `strong` element do in HTML?

#### --distractors--

Increases the font size.

---

Changes the text color.

---

Underlines the text.

#### --answer--

Makes text bold to show importance.

### --question--

#### --text--

What is the main difference between the `figure` and `figcaption` elements in HTML?

#### --distractors--

`figure` is used for captions, while `figcaption` is used to group related content like images or diagrams.

---

`figcaption` must always be placed outside the `figure` element.

---

There is no difference; both are used for the same purpose.

#### --answer--

`figure` groups related content like images or diagrams, while `figcaption` provides a caption for that content

### --question--

#### --text--

Why are HTML entities used?

#### --distractors--

To add styling to text.

---

To create hyperlinks in a webpage.

---

To increase the font size of special characters.

#### --answer--

To represent reserved characters like `<` and `&` in HTML.

### --question--

#### --text--

Which of the following statements about Open Graph tags is correct?

#### --distractors--

Open Graph tags are used to style a webpage with CSS.

---

Open Graph tags are only used for SEO and have no effect on social media.

---

Open Graph tags must be placed inside the `body` section of HTML.

#### --answer--

The `og:title` property sets the title that appears when content is shared on social media.

### --question--

#### --text--

Which of the following statements about image formats is incorrect?

#### --distractors--

WEBP and AVIF are better for modern image optimization.

---

SVG images can scale without losing quality.

---

Compression helps reduce image file sizes.

#### --answer--

PNG and JPG are the best formats for optimized images today.

### --question--

#### --text--

What does the `loop` attribute do in the `audio` element?

#### --distractors--

Plays the audio once.

---

Stops the audio after one play.

---

Slows down the audio playback.

#### --answer--

Repeats the audio continuously.

### --question--

#### --text--

Which of the following best describes an HTML boilerplate?

#### --distractors--

A special tool used by web developers to add watermarks to documents.

---

A browser plugin that speeds up webpage loading.

---

A coding framework exclusively for animations in HTML.

#### --answer--

A predefined template containing essential HTML structure for web development.
