---
id: 587d824e367417b2b2512c55
title: Test if an Object has a Property
challengeType: 2
forumTopicId: 301604
dashedName: test-if-an-object-has-a-property
---

# --description--

As a reminder, this project is being built upon the following starter project cloned from <a href="https://github.com/freeCodeCamp/boilerplate-mochachai/" target="_blank" rel="noopener noreferrer nofollow">GitHub</a>.

`property` asserts that the actual object has a given property.

# --instructions--

Within `tests/1_unit-tests.js` under the test labeled `#16` in the `Objects` suite, change each `assert` to either `assert.property` or `assert.notProperty` to make the test pass (should evaluate to `true`). Do not alter the arguments passed to the asserts.

# --hints--

All tests should pass.

```js
const response = await fetch(code + '/_api/get-tests?type=unit&n=15');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(data.state, 'passed');
```

You should choose the correct method for the first assertion - `property` vs. `notProperty`.

```js
const response = await fetch(code + '/_api/get-tests?type=unit&n=15');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(
  data.assertions[0].method,
  'notProperty',
  'A car has not wings'
);
```

You should choose the correct method for the second assertion - `property` vs. `notProperty`.

```js
const response = await fetch(code + '/_api/get-tests?type=unit&n=15');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(
  data.assertions[1].method,
  'property',
  'planes have engines'
);
```

You should choose the correct method for the third assertion - `property` vs. `notProperty`.

```js
const response = await fetch(code + '/_api/get-tests?type=unit&n=15');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.equal(data.assertions[2].method, 'property', 'Cars have wheels');
```

