---
id: 5900f3831000cf542c50fe96
title: 'Problem 23: Non-abundant sums'
challengeType: 1
forumTopicId: 301873
dashedName: problem-23-non-abundant-sums
---

# --description--

A perfect number is a number for which the sum of its proper divisors is exactly equal to the number. For example, the sum of the proper divisors of 28 would be 1 + 2 + 4 + 7 + 14 = 28, which means that 28 is a perfect number.

A number `n` is called deficient if the sum of its proper divisors is less than `n` and it is called abundant if this sum exceeds `n`.

As 12 is the smallest abundant number, 1 + 2 + 3 + 4 + 6 = 16, the smallest number that can be written as the sum of two abundant numbers is 24. By mathematical analysis, it can be shown that all integers greater than 28123 can be written as the sum of two abundant numbers. However, this upper limit cannot be reduced any further by analysis even though it is known that the greatest number that cannot be expressed as the sum of two abundant numbers is less than this limit.

Find the sum of all positive integers &lt;= `n` which cannot be written as the sum of two abundant numbers.

# --hints--

`sumOfNonAbundantNumbers(10000)` should return a number.

```js
assert.isNumber(sumOfNonAbundantNumbers(10000));
```

`sumOfNonAbundantNumbers(10000)` should return 3731004.

```js
assert.strictEqual(sumOfNonAbundantNumbers(10000), 3731004);
```

`sumOfNonAbundantNumbers(15000)` should return 4039939.

```js
assert.strictEqual(sumOfNonAbundantNumbers(15000), 4039939);
```

`sumOfNonAbundantNumbers(20000)` should return 4159710.

```js
assert.strictEqual(sumOfNonAbundantNumbers(20000), 4159710);
```

`sumOfNonAbundantNumbers(28123)` should return 4179871.

```js
assert.strictEqual(sumOfNonAbundantNumbers(28123), 4179871);
```

# --seed--

## --seed-contents--

```js
function sumOfNonAbundantNumbers(n) {

  return n;
}

sumOfNonAbundantNumbers(28123);
```

# --solutions--

```js
function abundantCheck(number) {
  let sum = 1;

  for (let i = 2; i <= Math.sqrt(number); i += 1) {
    if(number % i === 0) {
      sum += i + +(i !== Math.sqrt(number) && number / i);
    }
  }
  return sum > number;
}

function sumOfNonAbundantNumbers(n) {
  let sum = 0;
  const memo = {};
  let abundantList = [];

  // Function checkSum checks if num can be represented as a sum of numbers in the stack (array)
  const checkSum = (num, stack, memo) => {
    for (let i = 0; i < stack.length; i += 1) {
      if ((num - stack[i]) in memo) return true;
    }
    return false;
  };

  for (let i = 1; i <= n; i += 1) {
    if (abundantCheck(i)) {
      abundantList.push(i);
      memo[i] = 1;
    }
    if (checkSum(i, abundantList, memo)) continue;
    sum += i;
  }
  return sum;
}
```
