---
id: 6732c69d82814160951b1aa7
title: What Is the Number Constructor, and How Does It Work for Type Coercion?
challengeType: 19
dashedName: what-is-the-number-constructor-and-how-does-it-work-for-type-coercion
---

# --interactive--

The `Number()` constructor is used to create a number object. The number object contains a few helpful properties and methods like the `isNaN` and the `toFixed` method. Here's an example using the `Number()` constructor with the `new` keyword:

:::interactive_editor

```js
const myNum = new Number("34");
console.log(typeof myNum); // "object" 
```

:::

In this example we pass in a string literal to the `Number()` constructor and the return type is of type `object` instead of a `string`. 

When the `Number()` constructor is called as a function without the `new` keyword, then the return value will be the primitive number type. Most of the time you will be using the `Number()` constructor to convert other data types to the number data type. Here's an example of converting a string to a number:

:::interactive_editor

```js
const myNum = Number("100");
console.log(myNum); // 100

console.log(typeof myNum); // number
```

:::

This is helpful when you are getting input from the user and you need to convert that string input to a number so you can perform mathematical calculations. 

If you try to call the `Number()` constructor through an empty string then the result will be the number `0`: 

:::interactive_editor

```js
const num = Number("");
console.log(num); // 0
```

:::

This is because JavaScript will try to parse the string and since it doesn't contain any digits, the result will be zero.

If you try to pass in a string with random characters then the result will be `NaN` or "Not a Number". 

:::interactive_editor

```js
const num = Number("random");
console.log(num); // NaN
```

:::

When working with booleans, `true` returns `1` because `true` gets converted to one and `false` returns `0` because `false` is converted to zero. 

:::interactive_editor

```js
const boolTrue = Number(true);
const boolFalse = Number(false);

console.log(boolTrue); // 1
console.log(boolFalse); // 0
```

:::

If you pass in `null`, the result will be `0` and if you pass `undefined`, the result will be `NaN`. 

:::interactive_editor

```js
const undefinedNum = Number(undefined);
const nullNum = Number(null);

console.log(undefinedNum); // NaN
console.log(nullNum); // 0
```

:::

When working with arrays there are a few things to consider.

An empty array will return `0`. An array with a single number will return that number. An array with multiple numbers returns `NaN`. And an array with string(s) will also return `NaN`.

:::interactive_editor

```js
const emptyArr = Number([]);
const arrOneNum = Number([7]);
const arrMultiNum = Number([7, 36, 12]);
const arrStr = Number(["str1"]);
const arrMultiStr = Number(["str1", "str2"]);

console.log(emptyArr); // 0
console.log(arrOneNum); // 7
console.log(arrMultiNum); // NaN
console.log(arrStr); // NaN
console.log(arrMultiStr); // NaN
```

:::

When working with objects, the result is always `NaN`.

:::interactive_editor

```js
const obj1 = Number({});
const obj2 = Number({2: 2});
const obj3 = Number({key: "val"});
const obj4 = Number({key: true});

console.log(obj1); // NaN
console.log(obj2); // NaN
console.log(obj3); // NaN
console.log(obj4); // NaN
```

:::

In conclusion, you'll mostly use the `Number()` constructor for type conversion more than creating a number or a number object.

# --questions--

## --text--

What is the purpose of the `Number` constructor in JavaScript?

## --answers--

It only creates strings.

### --feedback--

Think about how you might turn a string into a number or create a new number in JavaScript.

---

It converts other data types to numbers and creates new number values.

---

It is used to manipulate arrays.

### --feedback--

Think about how you might turn a string into a number or create a new number in JavaScript.

---

It performs string concatenation.

### --feedback--

Think about how you might turn a string into a number or create a new number in JavaScript.

## --video-solution--

2

## --text--

How do you create a number object using the `Number` constructor in JavaScript?

## --answers--

By using the `Number.toString()` method.

### --feedback--

Think about how you might create an instance of an object in JavaScript.

---

By initializing it with the new keyword and passing a number as an argument.

---

By declaring a variable with the `var` keyword.

### --feedback--

Think about how you might create an instance of an object in JavaScript.

---

By calling `Number.parseInt()` with a string value.

### --feedback--

Think about how you might create an instance of an object in JavaScript.

## --video-solution--

2

## --text--

Which of these is one of the correct ways JavaScript handles arrays when converting them to numbers using the `Number` constructor?

## --answers--

An empty array returns `NaN`.

### --feedback--

Think about how different array structures might behave during conversion.

---

An array with multiple numbers converts to their sum.

### --feedback--

Think about how different array structures might behave during conversion.

---

An array with a single number converts to that number, while an empty array returns `0`.

---

An array with string(s) converts to `NaN`.

### --feedback--

Think about how different array structures might behave during conversion.

## --video-solution--

3
