---
id: 67329f9e9eb84e5c6a5e4366
title: What Is a String Object, and How Does It Differ from String Primitive?
challengeType: 19
dashedName: what-is-a-string-object-and-how-does-it-differ-from-string-primitive
---

# --interactive--

In previous modules you have been used to working with strings literals like this:

```js
const greeting = "Hello, World!";
```

But JavaScript also has string objects. Both string objects and string primitives are used to handle text but they function differently under the hood. A string object is created using the string constructor function, which wraps the primitive value in an object. Here is how you would create a string object:

:::interactive_editor

```js
const greetingObject = new String("Hello, World!");

console.log(typeof greetingObject); // "object"
```

:::

When we use the `typeof` operator we can see that the result is of type object instead of type string. One of the things that you might have been wondering about is how you can use properties like the `.length` property on string primitives.

When you use the `length` property on a string primitive, JavaScript temporarily wraps the string primitive in a string object, to perform the operation. This is why you can use the `length` property and the different methods like `repeat()`, `concat()`, and `slice()`. These types of methods and properties are referred to as instance methods, instance properties, and static methods. You will learn about how that works in detail in future modules.

One key difference between a string object and a string primitive is how it relates to memory and performance. String primitives are usually more memory efficient and faster compared to string objects. Although you will primarily work with string primitives in your code, it's still useful to understand how string objects work.

# --questions--

## --text--

What is the main difference between a string primitive and a string object in JavaScript?

## --answers--

String primitives are objects, while string objects are not.

### --feedback--

Think about how each type is represented and what they offer in terms of functionality.

---

String primitives are lighter and more efficient, while string objects provide additional properties and methods.

---

String objects cannot access methods like `.toUpperCase()`.

### --feedback--

Think about how each type is represented and what they offer in terms of functionality.

---

String primitives can change their value after they are created.

### --feedback--

Think about how each type is represented and what they offer in terms of functionality.

## --video-solution--

2

## --text--

Which of the following correctly describes the `.length` property of a string?

## --answers--

It changes the value of a string.

### --feedback--

Focus on what the `.length` property provides when used on a string.

---

It returns the number of characters in a string.

---

It works only on string objects.

### --feedback--

Focus on what the `.length` property provides when used on a string.

---

It adds new characters to the string.

### --feedback--

Focus on what the `.length` property provides when used on a string.

## --video-solution--

2

## --text--

What will the following code output?

```js
let str = "JavaScript";
let objStr = new String("JavaScript");
console.log(str.length === objStr.length);
```

## --answers--

`true`

---

`false`

### --feedback--

Remember that both string primitives and string objects have access to the `.length` property.

---

`undefined`

### --feedback--

Remember that both string primitives and string objects have access to the `.length` property.

---

It throws an error.

### --feedback--

Remember that both string primitives and string objects have access to the `.length` property.

## --video-solution--

1
