---
id: 6733696567d2273540aa6033
title: What Is the Web Animations API, and How Does It Relate to CSS Animation Properties?
challengeType: 19
dashedName: what-is-the-web-animations-api-and-how-does-it-relate-to-css-animation-properties
---

# --interactive--

The `Web Animations` API (WAAPI) allows you to create and control animations directly within JavaScript. With WAAPI, you can work with animations more dynamically, making it easier to manipulate them.

Let's take a look at WAAPI in more detail, so you can start working with animations directly inside your JavaScript code. At the core of WAAPI is the `Animation` constructor, which provides several instance methods and properties that allow you to dynamically animate elements.

A significant method in the `Animation` constructor is `animate()`. It allows you to create an animation by specifying keyframes and options like duration, direction, easing, and iterations.

Here's the basic syntax of the `animate()` method:

```js
element.animate(keyframes, options);
```

Let's look at an example. 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="square" id="square"></div>
<script src="index.js"></script>
```

```css
body {
  background: #f1f1f1;
  display: flex;
  align-items: center;
  justify-content: center;
  height: 100vh;
}

.square {
  background: #1b1b32;
  width: 10rem;
  aspect-ratio: 1/1;
}
```

```js
const square = document.querySelector("#square");

const animation = square.animate(
  [{ transform: "translateX(0px)" }, { transform: "translateX(100px)" }],
  {
    duration: 2000, // makes animation lasts 2 seconds
    iterations: Infinity, // loops indefinitely
    direction: "alternate", // moves back and forth
    easing: "ease-in-out" // smooth easing
  }
);
```

:::

The result in the browser will be a blue square moving back and forth horizontally.

The instance methods of the `Animation` constructor include:

```js
play()
pause()
reverse()
finish()
cancel()
```

And the instance properties include:

```md
playbackRate
currentTime
startTime
effect
timeline
playState
finished
onfinish
oncancel
```

Let's modify the example to use the `play()`, `pause()` methods and the `onfinish` property. Here is new version:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="square" id="square"></div>

<button id="playBtn">Play</button>
<button id="pauseBtn">Pause</button>
<script src="index.js"></script>
```

```css
body {
  background: #f1f1f1;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  height: 100vh;
}
.square {
  background: #1b1b32;
  width: 10rem;
  aspect-ratio: 1/1;
  margin-bottom: 20px;
}
button {
  margin: 10px;
  padding: 10px 20px;
  font-size: 16px;
}
```

```js
const square = document.querySelector("#square");
const playBtn = document.querySelector("#playBtn");
const pauseBtn = document.querySelector("#pauseBtn");

const animation = square.animate(
  [{ transform: "translateX(0px)" }, { transform: "translateX(200px)" }],
  {
    duration: 5000, // Animation lasts 5 seconds
    // iterations: Infinity, // Loops indefinitely
    direction: "alternate", // Moves back and forth
    easing: "ease-in-out" // Smooth easing function
  }
);

// Set the onfinish property to log a message when the animation ends
animation.onfinish = () => {
  console.log("Animation finished!");
};

// Play the animation when the "Play" button is clicked
playBtn.addEventListener("click", () => {
  animation.play();
  console.log("You start the animation");
});

// Pause the animation when the "Pause" button is clicked
pauseBtn.addEventListener("click", () => {
  animation.pause();
  console.log("You pause the animation");
});
```

:::

The result in the browser will show the blue box moving from left to right when the `play` button is clicked.

WAAPI extends the capabilities of CSS animations by providing more dynamic control over animations right inside JavaScript.

With CSS animations, you define animations declaratively using properties like `animation-name`, `animation-duration`, and `animation-timing-function`. You also have the opportunity to do the same thing using the `animate()` method of WAAPI.

The difference is that you can control the animations you create with the `animate()` method more directly and dynamically, but with CSS animations, you need to do way more by defining custom styles and triggering them inside your JavaScript file.

CSS animation is ideal for simple and declarative animations that run automatically. Those include hover effects, transitions or animations that don't need much interaction once triggered. If your animation needs to respond to user interactions like clicks, and scrolls, or you want the user to be able to pause, reverse, or change speed dynamically, WAAPI is the better choice. 

You can consider combining both WAAPI and CSS animations when you want the simplicity of CSS for basic setup but need to control animations at runtime.

# --questions--

## --text--

What is the primary method in the Web Animations API (WAAPI) for creating animations?

## --answers--

`setInterval()`

### --feedback--

Think about the method that allows you to define keyframes and options like duration.

---

`setTimeout()`

### --feedback--

Think about the method that allows you to define keyframes and options like duration.

---

`animate()`

---

`requestAnimationFrame()`

### --feedback--

Think about the method that allows you to define keyframes and options like duration.

## --video-solution--

3

## --text--
Which of these is not an instance method of the `Animation` constructor in the Web Animations API (WAAPI)?

## --answers--

`play()`

### --feedback--

Think about the methods used to control animations.

---

`pause()`

### --feedback--

Think about the methods used to control animations.

---

`reverse()`

### --feedback--

Think about the methods used to control animations.

---

`stop()`

## --video-solution--

4

## --text--

When should you use WAAPI over CSS animations?

## --answers--

For simple, automatic hover effects.

### --feedback--

Think about situations where you need more control over the animation.

---

When you need animations to respond to user interactions like clicks, scrolls, or allow dynamic control such as pausing or reversing.

---

When you only need transitions with no interaction.

### --feedback--

Think about situations where you need more control over the animation.

---

For animations that don't require much interaction after being triggered.

### --feedback--

Think about situations where you need more control over the animation.

## --video-solution--

2
