---
id: 6733694805a85d34ced08a9b
title: How Do the setTimeout and setInterval Methods Work?
challengeType: 19
dashedName: how-do-the-settimeout-and-setinterval-methods-work
---

# --interactive--

When building your programs, you'll often want something to happen after a delay, or repeat at regular intervals. That's where the `setTimeout()` and `setInterval()` methods come in handy. Both methods accept two parameters: a function and a delay.

Let's look at each of the methods in more detail so you can start using them in your web projects. 

`setTimeout()` lets you delay an action for a specified time. Here's the basic syntax of the `setTimeout()` method:

```js
setTimeout(functionToRun, delay);
```

`functionToRun` is the code you want to execute after a specified delay, and `delay` is the time (in milliseconds) to wait before running the function. Here's an example:

:::interactive_editor

```js
setTimeout(function () {
 console.log("This runs after 3 seconds");
}, 3000);
```

:::

You can also use an arrow function for the callback, like this:

:::interactive_editor

```js
setTimeout(() => {
 console.log("This runs after 3 seconds"); 
}, 3000);
```

:::

`setInterval()` keeps repeating a function at a set interval. It's like having an alarm that goes off every few seconds. `setInterval()` is perfect when you want something to happen over and over again, like refreshing data or creating an animation that moves continuously.

Just like `setTimeout()`, it takes a function and a delay:

```js
setInterval(functionToRun, delay);
```

`functionToRun` is the code you want to run repeatedly, while `delay` is the time in milliseconds between each execution of that function. Here's an example:

:::interactive_editor

```js
setInterval(() => {
 console.log("This runs every 2 seconds");
}, 2000);

// Result:
// This runs every 2 seconds
// This runs every 2 seconds
// This runs every 2 seconds
// ...
```

:::

Since `setInterval()` keeps executing the provided function at the specified interval, you might want to stop it. To do this, you have to use the `clearInterval()` method.

To do the work, `clearInterval()` takes the ID of the `setInterval()` you want to stop. This could be a variable you assign the interval to. One way to stop the interval is inside a `setTimeout()`, as that will stop the interval after a certain time:

:::interactive_editor

```js
const intervalID = setInterval(() => {
 console.log("This will stop after 5 seconds");
}, 1000);

setTimeout(() => {
 clearInterval(intervalID);
}, 5000);
```

:::

You can also stop a timeout with the `clearTimeout()` method:

:::interactive_editor

```js
let timeoutID = setTimeout(() => {
 console.log("This will not run");
}, 5000);

clearTimeout(timeoutID);
```

:::

With that code, the `setTimeout()` will not run at all. So, a more elegant way to do it is through the DOM, by adding a click event listener to a button to stop the timeout:

:::interactive_editor

```html
<h1>Cancel Timeout Example</h1>
<button id="cancelButton">Cancel Timeout</button>
<script src="index.js"></script>
```

```js
let timeoutID = setTimeout(() => {
  console.log("This will run if not canceled");
}, 5000);

document
.querySelector("#cancelButton")
.addEventListener("click", () => {
  clearTimeout(timeoutID);
  console.log("Timeout canceled!");
});
```

:::

# --questions--

## --text--

What do both `setTimeout()` and `setInterval()` methods take as parameters?

## --answers--

A variable and a number.

### --feedback--

Think about what needs to be executed and how long to wait.

---

A function and a delay.

---

A string and a boolean.

### --feedback--

Think about what needs to be executed and how long to wait.

---

A loop and a condition.

### --feedback--

Think about what needs to be executed and how long to wait.

## --video-solution--

2

## --text--

What does the `setInterval()` method do in JavaScript?

## --answers--

It runs a function once after a delay.

### --feedback--

Think about the function that runs over and over again at regular intervals.

---

It repeatedly runs a function at a set interval, like an alarm going off every few seconds.

---

It stops a function from executing.

### --feedback--

Think about the function that runs over and over again at regular intervals.

---

It pauses a function for a set amount of time.

### --feedback--

Think about the function that runs over and over again at regular intervals.

## --video-solution--

2

## --text--

What does the `setTimeout()` method do in JavaScript?

## --answers--

It delays an action for a specified time and then runs a function.

---

It runs a function immediately after being called.

### --feedback--

Think about when you want JavaScript to wait before executing a function.

---

It repeats a function at regular intervals.

### --feedback--

Think about when you want JavaScript to wait before executing a function.

---

It stops a function from running after a delay.

### --feedback--

Think about when you want JavaScript to wait before executing a function.

## --video-solution--

1
