---
id: 6733692ffe1da034469f7917
title: How Do You Manipulate Styles Using Element.style and Element.classList?
challengeType: 19
dashedName: how-do-you-manipulate-styles-using-elementstyle-and-elementclasslist
---

# --interactive--

There will be times when you will need to manipulate the styles of an HTML element inside your JavaScript file. An example of this would be when you need to hide or show a menu when a user clicks on a button.

In this lesson, you will learn how to manipulate styles using the `Element.style` and `Element.classList` properties.

The `Element.style` property is a read-only property that represents the inline style of an element. You can use this property to get or set the style of an element.

Here is an example of a paragraph element with an ID of `para`:

```html
<p id="para">This is a paragraph</p>
```

You can use the `style` property to change the color of the paragraph element to red:

:::interactive_editor

```html
<p id="para">This is a paragraph</p>
<script src="index.js"></script>
```

```js
const paraEl = document.getElementById("para");
paraEl.style.color = "red";
```

:::

The `style` property can be used to set many CSS properties, such as `color`, `background-color`, `font-size`, `font-weight`, and so on.

Another way to manipulate styles is by using the `Element.classList` property. The `classList` property is a read-only property that can be used to add, remove, or toggle classes on an element. Let's take a look at a couple of examples.

In this example, you are going to add a class called `highlight` to a paragraph element with an ID of `para`. In the CSS, we will set the `highlight` class to change the background color of the paragraph element to yellow. In the JavaScript, we will add the `highlight` class to the paragraph element using the `classList.add()` method. 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<p id="para">This is a paragraph</p>
<script src="index.js"></script>
```

```css
.highlight {
  background-color: yellow;
}
```

```js
const paraEl = document.getElementById("para");
paraEl.classList.add("highlight");
```

:::

You can also add multiple classes to an element by passing them as arguments to the `classList.add()` method:

```js
classList.add("class1", "class2", "class3");
```

If you need to remove a class from an element, you can use the `classList.remove()` method like this:

```js
classList.remove("highlight");
```

To toggle a class on an element, you can use the `classList.toggle()` method. In this example, we have a `button` element with an ID of `toggle-btn` and a `nav` element with an ID of `menu`. Inside the CSS, we have added some styles for the menu and a class called `show` that will change the `display` property of the `.menu` to `block`. Inside the JavaScript, we are accessing the menu element and the `button` element using the `getElementById()` method. Then, we are adding an event listener to the `button` element that will toggle the `show` class on the `.menu` element when the button is clicked:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<button id="toggle-btn">Toggle Menu</button>

<nav id="menu" class="menu">
  <ul>
    <li>Home</li>
    <li>About</li>
    <li>Products</li>
  </ul>
</nav>
<script src="index.js"></script>
```

```css
.menu {
  display: none;
  background-color: lightgray;
  width: 50%;
  padding: 10px;
}

.menu.show {
  display: block;
}
```

```js
const menu = document.getElementById("menu");
const toggleBtn = document.getElementById("toggle-btn");

toggleBtn.addEventListener("click", () => menu.classList.toggle("show"));
```

:::

When a user clicks on the button, the `show` class will be added to the `.menu` element, and the menu will be displayed. If the user clicks on the button again, the `show` class will be removed from the `.menu` element, and the menu will be hidden.

By using methods and properties such as `style`, `add()`, `remove()`, and `toggle()`, you can easily manipulate an element's styles with JavaScript, creating dynamic and interactive web pages.

# --questions--

## --text--

Which property would you use to directly change the color of an element's text using JavaScript?

## --answers--

`Element.classList`

### --feedback--

This property allows you to set inline CSS styles directly.

---

`Element.style`

---

`Element.innerHTML`

### --feedback--

This property allows you to set inline CSS styles directly.

---

`Element.getAttribute`

### --feedback--

This property allows you to set inline CSS styles directly.

## --video-solution--

2

## --text--

How would you add multiple classes to an element using the `Element.classList` property?

## --answers--

`classList.add("class1 class2 class3")`

### --feedback--

Review the portion of the lesson that discusses adding multiple classes to an element.

---

`classList.add("class1", "class2", "class3")`

---

`classList.append("class1", "class2", "class3")`

### --feedback--

Review the portion of the lesson that discusses adding multiple classes to an element.

---

`classList.insert("class1", "class2", "class3")`

### --feedback--

Review the portion of the lesson that discusses adding multiple classes to an element.

## --video-solution--

2

## --text--

What will happen if you click the button in the provided example multiple times?

## --answers--

The menu will be permanently visible.

### --feedback--

The button's event listener uses a method that alternates the class on the menu.

---

The menu will be permanently hidden.

### --feedback--

The button's event listener uses a method that alternates the class on the menu.

---

The menu will toggle between visible and hidden each time the button is clicked.

---

The menu will display an error message.

### --feedback--

The button's event listener uses a method that alternates the class on the menu.

## --video-solution--

3
