---
id: 673369067f824d33a90a0534
title: How Does the addEventListener Method Work?
challengeType: 19
dashedName: how-does-the-addeventlistener-method-work
---

# --interactive--

When the user clicks on a button or there is a change in a form, this is known as an event. In your programs, you will need to have a way to listen for these events and respond to them.

The `addEventListener()` method is used to listen for events. It takes two arguments: the event you want to listen for and a function that will be called when the event occurs.

Here is the basic syntax:

```js
element.addEventListener("event", listener);
```

The element is the HTML element to monitor for events, and event specifies the type of event to listen for, such as `"click"`.

The listener is an object that will receive the notification when the event occurs. Most of the time, this will be a function that you define to handle the event.

Here is an example:

```js
element.addEventListener("click", () => {
  // code to run when the click event occurs
});
```

You can also choose to pass in a function reference like this:

```js
function handleClick() {
  // code to run when the click event occurs
}

element.addEventListener("click", handleClick);
```

Sometimes you may want to create a separate function to handle the event. This can make your code easier to read and maintain.

The listener argument can also be `null`, or it can be an object that uses the `EventListener` interface. The `EventListener` interface defines a single method called `handleEvent()`. This method is automatically called whenever the event you're listening for occurs. Using this interface allows the same object to handle multiple events if needed.

Most of the time, you won't need to use this interface, and you can instead pass in a function that will be called when the event occurs.

Now, let's take a look at an example to better understand how this works:

In this example, we have a `button` element with the id of `btn`:

```html
<button id="btn">Show alert</button>
```

We want to listen for the `"click"` event on this button and show an alert when the button is clicked.

We first need to access that `button` element in our JavaScript code. Then we need to add an event listener to listen for the click event and show an alert when the button is clicked:

:::interactive_editor

```html
<button id="btn">Show alert</button>
<script src="index.js"></script>
```

```js
const btn = document.getElementById("btn");

btn.addEventListener("click", () => alert("You clicked the button"));
```

:::

Now each time the button is clicked, the user will see an alert message displayed on the screen like this:

```md
You clicked the button
```

Another type of event that you can listen for is the `"input"` event. This event is triggered when the value of an input element changes.

Here is an example:

```html
<input type="text" id="input" placeholder="Type something" />
```

We want to listen for the input event on this input element and log the value of the input to the console each time the user types something.

We first need to access that `input` element in our JavaScript code. Then we need to add an event listener to listen for the input event and log the value of the input to the console each time the user types something:

:::interactive_editor

```html
<input type="text" id="input" placeholder="Type something" />
<script src="index.js"></script>
```

```js
const input = document.getElementById("input");

input.addEventListener("input", () => {
  console.log(input.value);
});
```

:::

There are many more events that you can listen for using the `addEventListener()` method. Some common events include `mouseover`, `mouseout`, `keydown`, `keyup`, and `submit`.

In future lessons, we will cover more events and how to use the `addEventListener()` method to listen for them.

# --questions--

## --text--

What is the purpose of the `addEventListener()` method?

## --answers--

To create new HTML elements.

### --feedback--

Think about how events are handled in JavaScript.

---

To listen for events on an HTML element.

---

To modify the style of an element.

### --feedback--

Think about how events are handled in JavaScript.

---

To change the HTML content of an element.

### --feedback--

Think about how events are handled in JavaScript.

## --video-solution--

2

## --text--

What does the `EventListener` interface define?

## --answers--

Methods for creating new HTML elements.

### --feedback--

Think about what the interface is used for in relation to events.

---

The structure for event handling.

---

Properties of the HTML document.

### --feedback--

Think about what the interface is used for in relation to events.

---

Styles for event-driven elements.

### --feedback--

Think about what the interface is used for in relation to events.

## --video-solution--

2

## --text--

What type of event would you use `addEventListener()` with to capture user input in a text field?

## --answers--

`click`

### --feedback--

Consider what happens when a user types in an input field.

---

`keydown`

### --feedback--

Consider what happens when a user types in an input field.

---

`input`

---

`submit`

### --feedback--

Consider what happens when a user types in an input field.

## --video-solution--

3
