---
id: 673368e7bd043f331919514d
title: How Do the Navigator, Window, and Document Work?
challengeType: 19
dashedName: how-do-the-navigator-window-and-document-work
---

# --interactive--

When working with the DOM, you will often come across the `Navigator`, `Window`, and `Document` interfaces. An interface is a collection of methods and properties that define a particular object.

In this lesson, we will explore how these interfaces work and how you can use them in your web applications.

Let's start by looking at the `Navigator` interface.

The `Navigator` interface provides information about the browser environment, such as the user agent string, the platform, and the version of the browser. A user agent string is a text string that identifies the browser and operating system being used.

Here is an example of how to access the user agent string using the `Navigator` interface:

:::interactive_editor

```js
console.log(navigator.userAgent);
```

:::

The result will be a string that contains information about the browser and operating system being used.

Here is an example string that you might see:

```md
Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36
```

This could be helpful if you want to display different content based on the user's browser or operating system.

Another useful property of the `Navigator` interface is the `language` property, which returns the language of the browser. You can use this property to display content in the user's preferred language.

Here is an example of using the `language` property:

:::interactive_editor

```js
console.log(navigator.language);
```

:::

The result will be a string that contains the language code of the browser. If your preferred language is English, it will return `en-US`.

Next, let's look at the `Window` interface.

The `Window` interface represents the browser window that contains the DOM document. It provides methods and properties for interacting with the browser window, such as resizing the window, opening new windows, and navigating to different URLs.

Here is an example of working with the `innerWidth` property of the `Window` interface:

```js
console.log(window.innerWidth);
```

The result will be the width of the browser window in pixels. For example, if the browser window is 800 pixels wide, it will return `800`.

Another example would be the `location` property of the `Window` interface, which provides information about the current URL of the browser window:

:::interactive_editor

```js
console.log(window.location);
```

:::

The result will be an object that contains information about the current URL, such as the protocol, hostname, and pathname.

Most of the time you won't need to interact with the `Window` interface directly, as it is automatically available in the global scope of your JavaScript code.

For example, you can access the `location` property directly without using the `window` object:

:::interactive_editor

```js
console.log(location);
```

:::

You will see the same results as before when you were using `window.location`.

Finally, let's look at the `Document` interface.

The `Document` interface represents the DOM document that is displayed in the browser window. It provides methods and properties for interacting with the DOM, such as selecting elements, creating new elements, and modifying the content of elements.

Here is an example of using the `document.children` property:

:::interactive_editor

```html
<p>Hello, World!</p>
<script src="index.js"></script>
```

```js
console.log(document.children);
```

:::

The result will be an `HTMLCollection` object that contains all the child elements of the document.

There are many more properties and methods available on the `Document`, `Window`, and `Navigator` interfaces. However, this lesson has provided you with a basic understanding of how these interfaces work and how to use them in your web applications.

# --questions--

## --text--

What does the `navigator.userAgent` property return?

## --answers--

The width of the browser window.

### --feedback--

This property helps identify the browser and operating system.

---

The current URL of the browser window.

### --feedback--

This property helps identify the browser and operating system.

---

A string identifying the browser and operating system.

---

The language of the browser.

### --feedback--

This property helps identify the browser and operating system.

## --video-solution--

3

## --text--

Which property of the `Window` interface provides information about the current URL?

## --answers--

`window.innerWidth`

### --feedback--

This property helps you find out where the browser is currently navigating.

---

`window.location`

---

`window.navigator`

### --feedback--

This property helps you find out where the browser is currently navigating.

---

`window.document`

### --feedback--

This property helps you find out where the browser is currently navigating.

## --video-solution--

2

## --text--

How can you access the `Document` interface properties without explicitly using the `window` object?

## --answers--

By using `window.document`.

### --feedback--

This is automatically available in the global scope of your JavaScript code.

---

By using `document`.

---

By using `navigator.document`.

### --feedback--

This is automatically available in the global scope of your JavaScript code.

---

By using `navigator.window`.

### --feedback--

This is automatically available in the global scope of your JavaScript code.

## --video-solution--

2
