---
id: 673368c0161e6b326a7e03f0
title: How Do You Create New Nodes Using innerHTML and createElement()?
challengeType: 19
dashedName: how-do-you-create-new-nodes-using-innerhtml-and-createelement
---

# --interactive--

Let's see how you can create nodes with `innerHTML` and `createElement()`.

We'll start with `innerHTML`.

`innerHTML` is a property of `Element` objects that you can use to set their HTML markup. With `innerHTML`, you can set the HTML structure of an existing element with a string, creating all the necessary nodes.

This is an example. We have an empty `div` and we'll add some elements within it using the `innerHTML` property:

```html
<div id="container">
  <!-- Add new elements here -->
</div>
```

First, we need to select the element by its ID:

```js
const container = document.getElementById("container");
```

Then, we set the `innerHTML` property of the container to a string. This string has to have all the markup necessary to represent the nodes and the structure that you want to create. You can think of it as writing HTML within a string.

:::interactive_editor

```html
<div id="container"></div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
container.innerHTML = "<ul><li>Cheese</li><li>Tomato</li></ul>";
```

:::

We will set the `innerHTML` of this element to an unordered list of pizza ingredients (cheese and tomato).

You can also write the string on multiple lines if it makes the markup easier to understand. The important thing is that the markup accurately represents the HTML structure you want to create.

After running this code, you will see the following HTML structure if you inspect your markup. 

```html
<div id="container">
  <ul>
    <li>Cheese</li>
    <li>Tomato</li>
  </ul>
</div>
```

The new nodes were created and added dynamically to the DOM after the string was parsed.

`innerHTML` can be very helpful for certain scenarios. However, it does have some security risks that you should be familiar with. You shouldn't use it if you won't have full control over the string. 

For example, if the string will be entered by the user, you shouldn't use `innerHTML` because the user might insert malicious content into your website. Because of this, it’s usually recommended to use `textContent` instead, to insert plain text.

Another way to create a new node is by using the `createElement()` method. With this new method, you can create a new element by specifying its tag name. 

For example, if you want to create an image element, you would pass the `img` tag as a string when calling this method:

```js
document.createElement("img");
```

And you can assign this new object to a variable:

```js
const img = document.createElement("img");
```

The `createElement()` method returns a new `HTMLElement` object if the document is an `HTMLDocument`.  Else, it returns an `Element` object.

Once you have this new element ready, you can add it to the DOM as a child of another existing element using the `appendChild()` method, or you can insert it at a specific location using other methods. Choose the one that best fits your needs.

:::interactive_editor

```html
<div id="container"></div>
<script src="index.js"></script>
```

```js
const container = document.getElementById("container");
const img = document.createElement("img");
img.src = "https://cdn.freecodecamp.org/curriculum/cat-photo-app/lasagna.jpg";
img.alt = "A slice of lasagna on a plate.";
container.appendChild(img);
```

:::

Creating nodes with `innerHTML` and `createElement()` allows you to dynamically manipulate the structure and content of your websites. By combining these techniques, you can build interactive web applications.

# --questions--

## --text--

What is the primary purpose of the `innerHTML` property?

## --answers--

To update HTML elements.

### --feedback--

Think about how `innerHTML` is used to manipulate the structure of an element.

---

To set the text content of an element.

### --feedback--

Think about how `innerHTML` is used to manipulate the structure of an element.

---

To modify the attributes of an element.

### --feedback--

Think about how `innerHTML` is used to manipulate the structure of an element.

---

To dynamically inject HTML content into an element.

## --video-solution--

4

## --text--

Which of the following methods is used to create a new HTML element in JavaScript?

## --answers--

`createElement()`

---

`createNode()`

### --feedback--

Think about how to create a new element from scratch.

---

`appendChild()`

### --feedback--

Think about how to create a new element from scratch.

---

`getElementById()`

### --feedback--

Think about how to create a new element from scratch.

## --video-solution--

1

## --text--

What is the main risk of using `innerHTML` when you do not have control over the string?

## --answers--

Causing an infinite loop.

### --feedback--

Think about the potential for code injection when using `innerHTML` with untrusted input.

---

Insertion of malicious content.

---

Performance issues.

### --feedback--

Think about the potential for code injection when using `innerHTML` with untrusted input.

---

Accessibility issues.

### --feedback--

Think about the potential for code injection when using `innerHTML` with untrusted input.

## --video-solution--

2
