---
id: 673263df0eb568a7b450f2fc
title: How Do You Create a Newline in Strings and Escape Strings?
challengeType: 19
dashedName: how-do-you-create-a-newline-in-strings-and-escape-strings
---

# --interactive--

When working with strings in JavaScript, there are times when you need to include special characters that the JavaScript engine might otherwise misinterpret.

Two common tasks involve creating a newline within a string and escaping certain characters (like quotes) to make sure they appear correctly.

In many programming languages, including JavaScript, you can create a newline in a string using a special character called an escape sequence. The most common escape sequence for newlines is `\n`.

For example, if you want to break a string into multiple lines, you would use `\n` where you want the new line to begin:

:::interactive_editor

```js
let poem = "Roses are red,\nViolets are blue,\nJavaScript is fun,\nAnd so are you.";
console.log(poem);
```

:::

The `\n` escape sequence tells JavaScript to insert a line break at that point, which results in the string being displayed across multiple lines.

Another important concept when working with strings is escaping characters. Sometimes, you need to include characters in your string that JavaScript normally uses for something else, such as quotes.

If you simply use quotes inside a string without escaping them, it can cause an error because JavaScript will think you're trying to end the string.

For example, this will cause an error:

```js
let statement = "She said, "Hello!"";
```

JavaScript gets confused because it thinks the string ends after the word `"said,"` but, you want the quotes around `"Hello!"` to be part of the string.

To fix this, you can escape the inner quotes by placing a backslash (`\`) before them:

:::interactive_editor

```js
let statement = "She said, \"Hello!\"";
console.log(statement); // She said, "Hello!"
```

:::

The backslash tells JavaScript to treat the quotes as literal characters, so they appear correctly in the output.

You can also escape other special characters, such as the backslash itself (`\\`), or single quotes within a string surrounded by single quotes (`\'`).

Here's another example using single quotes:

:::interactive_editor

```js
let quote = 'It\'s a beautiful day!';
console.log(quote); // It's a beautiful day!
```

:::

By escaping the single quote with `\'`, JavaScript knows to include it as part of the string rather than ending the string early.

Escaping and creating newlines are essential when you’re formatting output or handling special characters in strings. These techniques help you prevent errors and ensure your text appears exactly as intended.

# --questions--

## --text--

Which of the following escape sequences would you use to create a new line in a string?

## --answers--

`\\`

### --feedback--

Think about how you would break a string into multiple lines.

---

`\t`

### --feedback--

Think about how you would break a string into multiple lines.

---

`\n`

---

`\"`

### --feedback--

Think about how you would break a string into multiple lines.

## --video-solution--

3

## --text--

Why is it necessary to escape certain characters within a string?

## --answers--

To perform mathematical operations on the string.

### --feedback--

Consider how JavaScript misinterprets special characters without escaping them.

---

To avoid syntax errors and ensure special characters are included in the string.

---

To combine two different strings into one.

### --feedback--

Consider how JavaScript misinterprets special characters without escaping them.

---

To change the string to uppercase.

### --feedback--

Consider how JavaScript misinterprets special characters without escaping them.

## --video-solution--

2

## --text--

How would you correctly include quotes within a string that is already wrapped in quotes?

## --answers--

Use single quotes inside double quotes.

### --feedback--

Think about how you can tell JavaScript to treat the inner quotes as part of the string.

---

Use the `\` character before the quotes you want to include.

---

Use `\n` to break the string.

### --feedback--

Think about how you can tell JavaScript to treat the inner quotes as part of the string.

---

JavaScript doesn't allow quotes inside other quotes.

### --feedback--

Think about how you can tell JavaScript to treat the inner quotes as part of the string.

## --video-solution--

2
