---
id: 672d2654f78cbf20e0ba4501
title: What Is Bracket Notation, and How Do You Access Characters from a String?
challengeType: 19
dashedName: what-is-bracket-notation-and-how-do-you-access-characters-from-a-string
---

# --interactive--

In JavaScript, strings are treated as sequences of characters, and each character in a string can be accessed using bracket notation. This allows you to retrieve a specific character from a string based on its position, which is called its index.

An index is the position of a character within a string, and it is zero-based. This means that the first character of a string has an index of `0`, the second character has an index of `1`, and so on.

For example, in the string `hello`, the character `h` is at index `0`, `e` is at index `1`, `l` is at index `2`, and so on.

Bracket notation uses square brackets (`[]`) and the index of the character you want to access. Let’s look at an example:

:::interactive_editor

```js
let greeting = "hello";
console.log(greeting[1]); // "e"
```

:::

In this example, we can access the character at index `1`, which is `e`.

To get the last character of a string, you can use the length of the string minus one.
The `length` property of a string tells you how many characters it contains, so to access the last character, you would subtract one from the length:

:::interactive_editor

```js
let greeting = "hello";
console.log(greeting[greeting.length - 1]); // "o"
```

:::

In this case, the `length` of `hello` is `5`, and the last character (`o`) is at index `4` which is `5 - 1`.

If you want to get multiple characters, you can use bracket notation like this:

:::interactive_editor

```js
let greeting = "hello";
let firstTwo = greeting[0] + greeting[1]; // "he"
console.log(firstTwo);
```

:::

In this example, we are concatenating the first and second characters using bracket notation to form the string `he`.

Bracket notation is useful when you need to access specific characters in a string, such as extracting initials from a name or checking a specific letter for validation.

# --questions--

## --text--

What is the index of the character `"r"` in the string `"JavaScript"`?

## --answers--

`2`

### --feedback--

Remember that index numbers start from `0`.

---

`4`

### --feedback--

Remember that index numbers start from `0`.

---

`6`

---

`8`

### --feedback--

Remember that index numbers start from `0`.

## --video-solution--

3

## --text--

How would you access the last character of a string using bracket notation?

## --answers--

`string[length]`

### --feedback--

Think about how to find the index of the last character.

---

`string[string.length]`

### --feedback--

Think about how to find the index of the last character.

---

`string[string.length - 1]`

---

`string[string - 1]`

### --feedback--

Think about how to find the index of the last character.

## --video-solution--

3

## --text--

What does bracket notation allow you to do with strings in JavaScript?

## --answers--

Add new characters to the string.

### --feedback--

Focus on how bracket notation interacts with individual characters.

---

Change the data type of the string.

### --feedback--

Focus on how bracket notation interacts with individual characters.

---

Access specific characters in the string using their index.

---

Convert the string into an array of characters.

### --feedback--

Focus on how bracket notation interacts with individual characters.

## --video-solution--

3
