---
id: 67326c0d7bef01c539120766
title: How Can You Test if a String Contains a Substring?
challengeType: 19
dashedName: how-can-you-test-if-a-string-contains-a-substring
---

# --interactive--

When working with strings in JavaScript, there are many cases where you might need to check whether a string contains a specific substring, which is a smaller part of that string.

For example, you might want to check if a user's input includes a specific word or character before performing some action. One way to achieve this is by using the `includes()` method.

The `includes()` method is used to check if a string contains a specific substring. If the substring is found within the string, the method returns `true` otherwise, it returns `false`.

Here's the basic syntax:

```js
string.includes(searchValue);
```

For the syntax, the `searchValue` is the substring you want to look for within the string. And here's an example:

:::interactive_editor

```js
let phrase = "JavaScript is awesome!";
let result = phrase.includes("awesome");

console.log(result);  // true
```

:::

In this example, the word `awesome` is found within the string `JavaScript is awesome!`, so the `includes()` method returns `true`.

It's important to note that the `includes()` method is case-sensitive. This means that the exact match of the characters is required, including their case.

For example:

:::interactive_editor

```js
let phrase = "JavaScript is awesome!";
let result = phrase.includes("Awesome");

console.log(result);  // false
```

:::

Since `Awesome` (with an uppercase `A`) does not match `awesome` (with a lowercase `a`), the result is `false`.

You can also use the `includes()` method to check for a substring starting at a specific index in the string by providing a second parameter:

:::interactive_editor

```js
let text = "Hello, JavaScript world!";
let result = text.includes("JavaScript", 7);

console.log(result);  // true
```

:::

Here, the search for the substring `JavaScript` starts from the 7th position in the string, ensuring it skips any characters before this position.

The `includes()` method only returns a `true` or `false` result. It does not provide information on where the substring is located in the string or how many times it occurs. If you need that level of detail, other methods, such as the `indexOf()` method might be more suitable.

# --questions--

## --text--

What does the `includes()` method return when a substring is found in a string?

## --answers--

The index of the substring.

### --feedback--

Consider what the method does when it detects the substring.

---

The length of the substring.

### --feedback--

Consider what the method does when it detects the substring.

---

`true`

---

`false`

### --feedback--

Consider what the method does when it detects the substring.

## --video-solution--

3

## --text--

Which of the following statements about the `includes()` method is correct?

## --answers--

It is case-insensitive.

### --feedback--

Think about whether it distinguishes between uppercase and lowercase characters.

---

It is case-sensitive.

---

It replaces the found substring with another value.

### --feedback--

Think about whether it distinguishes between uppercase and lowercase characters.

---

It returns the number of occurrences of the substring.

### --feedback--

Think about whether it distinguishes between uppercase and lowercase characters.

## --video-solution--

2

## --text--

What will the following code output?

```js
let message = "JavaScript is great!";
let result = message.includes("script");
console.log(result);
```

## --answers--

`true`

### --feedback--

Focus on whether `includes()` is case-sensitive.

---

`false`

---

`undefined`

### --feedback--

Focus on whether `includes()` is case-sensitive.

---

Throws an error.

### --feedback--

Focus on whether `includes()` is case-sensitive.

## --video-solution--

2
