---
id: 67326c3c3ab931c644cea05b
title: How Can You Trim Whitespace from a String?
challengeType: 19
dashedName: how-can-you-trim-whitespace-from-a-string
---

# --interactive--

When working with strings in JavaScript, it's common to encounter unwanted whitespace at the beginning or end of a string. Whitespace can interfere with operations like comparison, storage, or display, which is why it's important to know how to remove it efficiently.

In this lesson, we'll explore how you can trim whitespace using JavaScript's `trim()`, `trimStart()`, and `trimEnd()` methods.

Whitespace refers to spaces, tabs, or line breaks that occur in a string but are not visible characters. For example:

```js
let greeting = "   Hello, world!   ";
```

In this case, there are spaces before and after the visible text, `Hello, world!`.

The `trim()` method is the most commonly used way to remove whitespace from both the beginning and the end of a string. Here's an example:

:::interactive_editor

```js
let message = "   Hello!   ";
console.log(message); // "   Hello!   "
let trimmedMessage = message.trim();
console.log(trimmedMessage);  // "Hello!"
```

:::

In this case, the `trim()` method removes all the leading and trailing spaces, leaving just `Hello!`. Note that any whitespace within the string (between words, for example) is left untouched by `trim()`.

Sometimes, you may only want to remove whitespace from either the beginning or the end of a string, but not both. This is where `trimStart()` and `trimEnd()` come in.

`trimStart()` removes whitespace from the beginning (or start) of the string.

:::interactive_editor

```js
let greeting = "   Hello!   ";
console.log(greeting);  // "   Hello!   "
let trimmedStart = greeting.trimStart();
console.log(trimmedStart);  // "Hello!   "
```

:::

`trimEnd()` removes whitespace from the end of the string.

:::interactive_editor

```js
let greeting = "   Hello!   ";
console.log(greeting);  // "   Hello!   "
let trimmedEnd = greeting.trimEnd();
console.log(trimmedEnd);  // "   Hello!"
```

:::

These methods give you more precise control over which part of the string you want to clean up.

In summary, trimming whitespace is an essential part of working with strings in JavaScript. Whether you want to clean up input data or ensure consistent string comparisons, you can use `trim()` to remove whitespace from both sides of a string, or use `trimStart()` and `trimEnd()` to target specific sides.

# --questions--

## --text--

What does the `trim()` method do to a string in JavaScript?

## --answers--

Removes all spaces within a string

### --feedback--

Consider which parts of the string `trim()` affects.

---

Removes all whitespace from the beginning and end of a string.

---

Removes only spaces between words.

### --feedback--

Consider which parts of the string `trim()` affects.

---

Replaces all characters in a string with whitespace.

### --feedback--

Consider which parts of the string `trim()` affects.

## --video-solution--

2

## --text--

Which method would you use if you only want to remove whitespace from the start of a string?

## --answers--

`trim()`

### --feedback--

Think about which method targets the beginning of the string.

---

`trimEnd()`

### --feedback--

Think about which method targets the beginning of the string.

---

`trimStart()`

---

`replace()`

### --feedback--

Think about which method targets the beginning of the string.

## --video-solution--

3

## --text--

What will be the output of the following code?

```js
let str = "   Code   ";
console.log(str.trimEnd());
```

## --answers--

```js
"Code"
```

### --feedback--

Consider which part of the string is affected by `trimEnd()`.

---

```js
"   Code"
```

---

```js
"Code   "
```

### --feedback--

Consider which part of the string is affected by `trimEnd()`.

---

```js
" Code "
```

### --feedback--

Consider which part of the string is affected by `trimEnd()`.

## --video-solution--

2
