---
id: 67326c1fdaf9c0c5ad1a2589
title: How Can You Change the Casing for a String?
challengeType: 19
dashedName: how-can-you-change-the-casing-for-a-string
---

# --interactive--

When working with strings in JavaScript, there are many situations where you might need to adjust the case of the text, such as transforming all letters to uppercase for a heading or converting text to lowercase for uniformity.

Luckily, JavaScript makes this easy with two built-in methods: `toUpperCase()` and `toLowerCase()`.

The `toUpperCase()` method converts all the characters to uppercase letters and returns a new string with all uppercase characters. This is useful when you want to emphasize text or create consistency in the format of strings.

Let's see an example:

:::interactive_editor

```js
let greeting = "Hello, World!";
let uppercaseGreeting = greeting.toUpperCase();
console.log(uppercaseGreeting);  // "HELLO, WORLD!"
```

:::

In this code, the `toUpperCase()` method transforms the entire string into uppercase letters.

The original string remains unchanged because `toUpperCase()` returns a new string, rather than modifying the original one.

On the flip side, the `toLowerCase()` method converts all characters in a string to lowercase. This is helpful when you need to standardize input, such as when comparing user-provided text or making case-insensitive checks.

Let's look at an example:

:::interactive_editor

```js
let shout = "I AM LEARNING JAVASCRIPT!";
let lowercaseShout = shout.toLowerCase();
console.log(lowercaseShout);  // "i am learning javascript!"
```

:::

The `toLowerCase()` method converts all characters to lowercase, making the string less aggressive, while leaving the original string unchanged.

In summary, the `toUpperCase()` and `toLowerCase()` methods in JavaScript are powerful tools for transforming strings into all uppercase or lowercase letters.

These methods are particularly useful for standardizing text input, making case-insensitive comparisons, and ensuring design consistency.

With these simple yet effective methods, you can handle text manipulation in a more controlled and predictable way.

# --questions--

## --text--

What does the `toUpperCase()` method do when called on a string in JavaScript?

## --answers--

Converts only the first letter of the string to uppercase.

### --feedback--

Think about how `toUpperCase()` affects the entire string.

---

Converts all characters in the string to uppercase.

---

Converts all characters in the string to lowercase.

### --feedback--

Think about how `toUpperCase()` affects the entire string.

---

Reverses the string.

### --feedback--

Think about how `toUpperCase()` affects the entire string.

## --video-solution--

2

## --text--

What will the following code output?

```js
let phrase = "JavaScript is Fun!";
console.log(phrase.toLowerCase());
```

## --answers--

`JAVASCRIPT IS FUN!`

### --feedback--

Consider what happens when `toLowerCase()` is applied to a string.

---

`JavaScript is fun!`

### --feedback--

Consider what happens when `toLowerCase()` is applied to a string.

---

`javascript is fun!`

---

`Javascript Is Fun!`

### --feedback--

Consider what happens when `toLowerCase()` is applied to a string.

## --video-solution--

3

## --text--

In which scenario would you most likely use the `toLowerCase()` method?

## --answers--

When you want to make sure user input is standardized for case-insensitive comparisons.

---

When you need to capitalize the first letter of each word in a sentence.

### --feedback--

Think about how converting all characters to lowercase might help when dealing with user inputs.

---

When you want to replace spaces in a string with underscores.

### --feedback--

Think about how converting all characters to lowercase might help when dealing with user inputs.

---

When you want to reverse the characters in a string.

### --feedback--

Think about how converting all characters to lowercase might help when dealing with user inputs.

## --video-solution--

1
