---
id: 6729960ed6e2ca3825940e97
title: How Do You Represent Computer Code in HTML?
challengeType: 19
dashedName: how-do-you-represent-computer-code-in-html
---

# --interactive--

The inline code element is used to represent short snippets of code inside text. Common use cases for the code element would be for technical articles and documentation pages.

Here is an example of using the `code` element to show a CSS code snippet:

:::interactive_editor

```html
<p>
  To set the text color to blue in CSS, use the following code:
  <code>color: blue;</code>
</p>
```

:::

In this example, the CSS `color` property is used to set the text color to `blue`. By wrapping this code snippet inside `<code>` tags, it communicates to the browser that the text is a piece of inline code.

The browser will apply default styles for content inside of the `code` element. The default styling is a monospaced font.

The `code` element is meant to represent a single line of code. If you want to represent multiple lines of code, you will need to place a `code` element inside a preformatted text element.

The preformatted text element is used to represent preformatted text. Here is an example of using the preformatted text element to show a CSS declaration:

:::interactive_editor

```html
<pre>
  <code>
    body {
      color: red;
    }
  </code>
</pre>
```

:::

When using the `pre` element, you will need to be mindful of spacing because it will display exactly as written inside the HTML document.

In the browser, you will see that the code is indented several spaces to the right. If you were to change the indentation in the code example, then you will see a difference in indentation on the screen.

When it comes to including code examples inside your HTML document, you should use the `code` element for short inline examples. 

If you need to display longer code snippets, then you will need to use the `pre` and `code` elements.

# --questions--

## --text--

What is the `code` element used for?

## --answers--

It's used to create hyperlinks to other web pages.

### --feedback--

The name of this element implies what its use case is for.

---

It's used to format text with bold or italic styles.

### --feedback--

The name of this element implies what its use case is for.

---

It's used to represent short snippets of code inside text.

---

It's used to embed images and multimedia files.

### --feedback--

The name of this element implies what its use case is for.

## --video-solution--

3

## --text--

What is the preformatted text (`pre`) element used for?

## --answers--

It's used to apply CSS styles to text.

### --feedback--

The name of this element implies what it is used for.

---

It's used to create tables and structured layouts.

### --feedback--

The name of this element implies what it is used for.

---

It's used to represent preformatted text.

---

It's used to insert hyperlinks and email addresses.

### --feedback--

The name of this element implies what it is used for.

## --video-solution--

3

## --text--

What is the default styling for the `code` element?

## --answers--

Monospaced font.

---

Italic text with a colored background.

### --feedback--

Review the beginning of the lesson to see the examples rendered to the page.

---

Bold text with a larger font size.

### --feedback--

Review the beginning of the lesson to see the examples rendered to the page.

---

Underlined text with a fixed-width font.

### --feedback--

Review the beginning of the lesson to see the examples rendered to the page.

## --video-solution--

1
