---
id: 672bb83c3a9906945536cff2
title: What Are vh and vw Units, and When Should You Use Them?
challengeType: 19
dashedName: what-are-vh-and-vw-units
---

# --interactive--

In CSS, `vh` and `vw` are viewport-relative units that allow you to size elements based on the dimensions of the browser window. These units are particularly useful for creating responsive designs that adapt to different screen sizes.

`vh` stands for "viewport height," and `1vh` is equal to 1% of the viewport's height.

Similarly, `vw` stands for "viewport width," and `1vw` is equal to 1% of the viewport's width. 

This means that if you set an element's height to `100vh`, it will occupy the full height of the viewport, regardless of the actual pixel dimensions of the device.

These units are especially handy when you want to create full-screen layouts or elements that maintain a specific proportion of the screen. 

For example, you might want to use them to create a hero section that always fills the entire screen (to interact with the example, you will need to enable the interactive editor). 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />

<section class="hero">
  <h1>100vh / 100vw Example</h1>
  <p>This section fills the entire browser window.</p>
</section>
```

```css
body {
  margin: 0;
  font-family: sans-serif;
  border: 5px dashed #333;
}

.hero {
  height: 100vh;
  width: 100vw;
  background-color: #add8e6; 
  padding: 2em;
}

.hero h1 {
  font-size: 2em;
  margin-bottom: 0.5em;
}

.hero p {
  font-size: 1em;
}
```

:::

This CSS ensures that the hero section will always be exactly the size of the viewport, regardless of the device's screen size.

`vh` and `vw` units can also be used for typography to create responsive text sizes.

Enable the interactive editor and try adjusting the size of the preview window to see how the text scales with the viewport size:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<h1>Responsive Heading</h1>
<p>The h1 heading scales with the viewport width.</p>
```

```css
h1 {
  font-size: 5vw;
}
```

:::

This will set the font size of `h1` elements to 5% of the viewport width, allowing the text to scale smoothly with the browser window size.

One of the advantages of `vh` and `vw` units is that they respond to changes in the viewport size in real-time. This means that if a user resizes their browser window, elements sized with these units will adjust accordingly without needing to reload the page. However, it's important to use these units judiciously. Setting font sizes solely with `vw` units, for example, can lead to text becoming too small on narrow screens or too large on wide screens. 

Another consideration is that on mobile devices, the viewport height can change when the browser's address bar appears or disappears, which can cause unexpected layout shifts if you're using `vh` units extensively.

In summary, `vh` and `vw` units are powerful tools for creating responsive layouts and elements that adapt to the viewport size. They're particularly useful for full-screen sections, maintaining aspect ratios, and creating smoothly scaling designs. However, they should be used thoughtfully and often in combination with other CSS techniques to ensure the best user experience across all devices.

# --questions--

## --text--

What does `50vh` represent in CSS?

## --answers--

50 pixels.

### --feedback--

Think about what `vh` stands for and how it relates to the viewport.

---

Half the height of the viewport.

---

50% of the element's parent height.

### --feedback--

Think about what `vh` stands for and how it relates to the viewport.

---

Half the width of the viewport.

### --feedback--

Think about what `vh` stands for and how it relates to the viewport.

## --video-solution--

2

## --text--

Which of the following is a valid use case for `vw` units?

## --answers--

Setting a fixed width for a sidebar.

### --feedback--

Consider which scenario would benefit most from an element's size being directly tied to the viewport width.

---

Defining the maximum width of an image.

### --feedback--

Consider which scenario would benefit most from an element's size being directly tied to the viewport width.

---

Creating a square element that's always 20% of the viewport width.

---

Setting the `line-height` of paragraph text.

### --feedback--

Consider which scenario would benefit most from an element's size being directly tied to the viewport width.

## --video-solution--

3

## --text--

What potential issue might arise from using `vh` units for critical layout elements on mobile devices?

## --answers--

They're not supported on older mobile browsers.

### --feedback--

Think about how the visible area of a mobile browser can change during user interaction.

---

They can cause layout shifts when the mobile browser's address bar appears or disappears.

---

They make the website load slower on mobile devices.

### --feedback--

Think about how the visible area of a mobile browser can change during user interaction.

---

They don't work with touch screens.

### --feedback--

Think about how the visible area of a mobile browser can change during user interaction.

## --video-solution--

2
