---
id: 672bb7d659f0089377a91eab
title: What Are Percentages in CSS, and When Should You Use Them?
challengeType: 19
dashedName: what-are-percentages-in-css
---

# --interactive--

Percentages in CSS are relative units that allow you to define sizes, dimensions, and other properties as a proportion of their parent element. When you use a percentage value, you're essentially saying, "Make this X% of its container."

For example, if you set `width: 50%` on an element, it will occupy half the width of its parent container. This makes percentages incredibly useful for creating responsive designs that adapt to different screen sizes.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="container">
  <div class="box"></div>
</div>
```

```css
.container {
  width: 400px;
  height: 200px;
  background-color: lightgray;
}

.box {
  width: 50%;
  height: 100%;
  background-color: red;
}
```

:::

Percentages are ideal for creating fluid layouts that adjust to various screen sizes. For instance, setting a container to `width: 80%` ensures it takes up 80% of its parent's width, regardless of the device.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="parent">
  <div class="child"></div>
</div>
```

```css
.parent {
  width: 100%;
  height: 300px;
  background-color: lightblue;
}

.child {
  width: 80%;
  height: 100%;
  background-color: red;
}
```

:::

Using percentages for flexible images is another common practice. By applying `max-width: 100%` to images, you allow them to scale down on smaller screens while maintaining their aspect ratio.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<img src="https://placehold.co/150x150" alt="Example Product Image" />
```

```css
img {
  max-width: 100%;
  height: auto;
}
```

:::

While less common, percentages can also be used for font sizes to create scalable typography. For example, `font-size: 120%` would make the text 20% larger than its parent's font size.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="text-container">
  Parent text.
  <p class="text">This is some example text.</p>
</div>
```

```css
.text-container {
  font-size: 16px;
}

.text {
  font-size: 120%;
}
```

:::

Percentages can be particularly handy for vertical centering. Here's an example of how you might use percentages with the `transform` property to center an element vertically.

This example positions the element 50% from the top of its container, then uses `transform` to move it back up by half its own height, effectively centering it vertically.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="centered"></div>
```

```css
.centered {
  position: absolute;
  top: 50%;
  transform: translateY(-50%);
  width: 300px;
  height: 300px;
  background-color: red;
}
```

:::

You will learn more about how absolute positioning and the transform properties work in more detail in future lessons. 

Remember, percentages are always relative to something. For horizontal properties like `width`, they're relative to the parent's width. For vertical properties like `height`, they're usually relative to the parent's height (if specified).

However, be cautious when nesting elements with percentage-based dimensions, as this can lead to unexpected results. Also, keep in mind that percentage-based heights can be tricky if the parent doesn't have a defined height.

In summary, percentages in CSS are powerful tools for creating flexible, responsive designs. Use them when you want elements to scale proportionally to their containers or when you need layouts that adapt seamlessly to different screen sizes.

# --questions--

## --text--

What happens if you set `width: 50%` on an element whose parent has a `width` of `300px`?

## --answers--

The element will be `150px` wide.

---

The element will be `50px` wide.

### --feedback--

Remember that percentages are relative to the parent element's dimensions.

---

The element will be `600px` wide.

### --feedback--

Remember that percentages are relative to the parent element's dimensions.

---

The element will have no width.

### --feedback--

Remember that percentages are relative to the parent element's dimensions.

## --video-solution--

1

## --text--

In the following CSS rule, what does the percentage value affect?


```css
.box {
  margin-top: 10%;
}
```

## --answers--

The width of the element.

### --feedback--

Consider which property is being set and what it typically relates to.

---

The height of the element.

### --feedback--

Consider which property is being set and what it typically relates to.

---

The top margin of the element.

---

The font size of the element.

### --feedback--

Consider which property is being set and what it typically relates to.

## --video-solution--

3

## --text--

Which of the following is NOT a good use case for percentage values in CSS?

## --answers--

Setting the `width` of a responsive container.

### --feedback--

Think about which property typically requires more precise control and is less dependent on its parent's dimensions.

---

Defining the `border-radius` of a circular element.

### --feedback--

Think about which property typically requires more precise control and is less dependent on its parent's dimensions.

---

Scaling an image within its container.

### --feedback--

Think about which property typically requires more precise control and is less dependent on its parent's dimensions.

---

Specifying the `line-height` of text.

## --video-solution--

4
