---
id: 687ea86615674e19296a78ce
title: What Are Some Common Relational Databases, and How Do You Install and Use Postgres?
challengeType: 19
dashedName: what-are-some-common-relational-databases-and-how-do-you-install-and-use-postres
---

# --description--

Relational databases have a wide range of applications, including web development, inventory management systems, healthcare systems, e-commerce applications, and more.

Some of the most common relational databases are MySQL, PostgreSQL, SQLite, and Microsoft SQL Server. Let's learn a little bit about each one of them.

MySQL is an open-source relational database management system. It's very popular for web development because it's easy to use, reliable, and efficient for building real-world applications. It also has an active community of developers that support and maintain it.

PostgreSQL is officially described as "The World's Most Advanced Open Source Relational Database." It's a free, open source object-relational database system known for its reliability, data integrity, and extensibility. For example, you can define your own data types, custom functions, and write code in different programming languages without re-compiling your database.

SQLite is a free, open source, and lightweight file-based SQL database engine. It's one of the most widely used database engines in the world. SQLite is self-contained and serverless. It's a zero-configuration database, which means that it doesn't require an initial setup process, which is great for getting started quickly.

These three databases are free and open source. There are other popular proprietary options too, including Microsoft SQL Server and Oracle database.

Microsoft SQL server is a popular relational database management system developed by Microsoft and used in various applications.

Oracle database is a scalable relational database management system often used for enterprise applications that require high performance.

Great. Now that you know more about the different options available, let's see how you can install PostgreSQL.

First, you need to go to the official website: <a href="https://www.postgresql.org/" target="_blank">https://www.postgresql.org/</a>.

Once you're there, click on the "Download" button.

This will take you to a page where you can select your operating system. If you click on one, you will be taken to the instructions for that OS.

We will go through the installation process for the Windows operating system, but the process is similar across operating systems.

From this page, you can download the installer by clicking on the "Download the installer" link.

This will take you to a page where you can choose the version of PostgreSQL you want to install. If you click on the corresponding icon, the download should start.

Then, in your Downloads folder or the folder where you store your downloads by default, you should see the installer.

If you double-click on it, you will start the setup process. Click Next.

Choose the directory where PostgreSQL will be installed. You'll see one by default but you can customize it.

Then, select the component that you want to install. There are four possible components:

- PostgreSQL Server, the database engine itself.
- pgAdmin 4, a user-friendly tool for database management.
- Stack Builder, a tool for downloading and installing additional PostgreSQL-related software and extensions
- And Command Line Tools, to interact with the PostgreSQL server directly from your terminal. This includes psql, an interactive terminal for executing SQL queries.

When you're ready, click Next.

Then, select a directory to store your data. You will see a default path but you can customize this. When you're ready, click Next.

Now you'll need to enter a password for the database superuser, the user with unrestricted access to all databases and objects. Type in your password, retype it, and then click Next.

Then, select the port number the server should listen on. By default, it's 5432. Then, click Next.

You'll need to choose a locale for the new database cluster. This is important for the database to interpret locale-sensitive data types. Then, click Next.

Finally, you'll see a pre-installation summary. Take a moment to review this and click Next.

You will need to confirm that you want to start the installation process. If you click Next, the process will start. It should only take a few minutes.

When the process is completed, based on the components that you installed, you may have to choose if you want to launch Stack Builder to download and install additional tools, drivers, and applications.

If you decide to launch Stack Builder, you'll see a screen where you can start the installation. Alternatively, you can click Cancel to do this later on.

Congratulations! Now you have PostgreSQL installed on your computer. The process should be similar for other operating systems. After this, you can start using the database.

Go to your apps and search for pgAdmin, an open source administration and development platform for PostgreSQL that should have been installed if you selected it in the components. Click on pgAdmin 4 to open it.

You'll see an initial loading screen when the application starts. Then, you should see a dashboard where you can start a new server, check your databases, configure pgAdmin, and more. You'll also find helpful links to the documentation.

If you click on "Servers" at the top left, you will need to enter the password that you chose during the installation.

After entering your password, you should see a screen where you will have access to your databases, including their tables.

You'll also find another very helpful tool, psql, an interactive terminal for SQL queries. To open it, search for psql on your system. Click on it.

It will open the SQL Shell, where you can start running commands.

And that's how you can install PostgreSQL on Windows. The process is very similar for macOS and Linux.

Alternatively, if you are installing it on macOS, you can use Homebrew, a package manager. Once you have Homebrew installed, run this command to install PostgreSQL:

```bash
brew install postgresql@<version>
```

You can specify the version that you want to install by writing the number after the at (`@`) symbol.

# --questions--

## --text--

Which of the following is NOT a common relational database?

## --answers--

MySQL

### --feedback--

Think about the popular relational databases you learned about during the lesson.

---

Node

---

PostgreSQL

### --feedback--

Think about the popular relational databases you learned about during the lesson.

---

SQLite

### --feedback--

Think about the popular relational databases you learned about during the lesson.

## --video-solution--

2

## --text--

PostgreSQL is known for its:

## --answers--

Weak SQL support and limited features.

### --feedback--

Think about PostgreSQL's reputation regarding standards and customization.

---

Strong SQL support and powerful features.

---

Exclusive use in small systems.

### --feedback--

Think about PostgreSQL's reputation regarding standards and customization.

---

Small developer community.

### --feedback--

Think about PostgreSQL's reputation regarding standards and customization.

## --video-solution--

2

## --text--

Which of the following is an open source, lightweight, file-based relational database?

## --answers--

Microsoft SQL Server

### --feedback--

Think about which option is known for its simplicity.

---

PostgreSQL

### --feedback--

Think about which option is known for its simplicity.

---

SQLite

---

MySQL

### --feedback--

Think about which option is known for its simplicity.

## --video-solution--

3
